/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

public interface Matchable {
    public String getMethodShortClassName();

    public boolean hasWithSameValue();

    public String getFullyQualifiedNameOfGeneratedClass();

    public String getSimpleNameOfGeneratedInterfaceMatcher();

    default public long getCompatibility() {
        return 7L;
    }

    default public String getMethodNameDSLWithSameValue() {
        return this.getMethodShortClassName() + "WithSameValue";
    }

    default public String getMethodNameDSLWithParent() {
        return this.getMethodShortClassName() + "WithParent";
    }

    default public String getWithSameValue(boolean hasReference) {
        return this.getFullyQualifiedNameOfGeneratedClass() + (hasReference ? "::" : ".") + this.getMethodNameDSLWithSameValue();
    }

    default public boolean supportIgnore() {
        return (this.getCompatibility() & 1L) == 1L;
    }

    default public boolean supportCycleDetectionV1() {
        return (this.getCompatibility() & 2L) == 2L;
    }

    default public boolean supportSameValueWithParentPostPrecessor() {
        return (this.getCompatibility() & 4L) == 4L;
    }

    public static Matchable of(final String fullName, final String methodName, final String interfaceName, final boolean hasWithSameValue, final long compatibility) {
        return new Matchable(){

            @Override
            public boolean hasWithSameValue() {
                return hasWithSameValue;
            }

            @Override
            public String getSimpleNameOfGeneratedInterfaceMatcher() {
                return interfaceName;
            }

            @Override
            public String getMethodShortClassName() {
                return methodName;
            }

            @Override
            public String getFullyQualifiedNameOfGeneratedClass() {
                return fullName;
            }

            @Override
            public long getCompatibility() {
                return compatibility;
            }
        };
    }
}

