/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.extension;

import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.extension.AbstractDSLExtensionSupplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class ArrayContaingDSLExtensionSupplier
extends AbstractDSLExtensionSupplier {
    private final String javadoc;
    private final String matcher;
    private final ProvidesMatchersAnnotatedElementData element;

    public ArrayContaingDSLExtensionSupplier(ProvidesMatchersAnnotatedElementData element, String methodName, String javadoc, String matcher) {
        super(element.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), element.getFullGeneric() + " org.hamcrest.Matcher<" + element.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric() + "[]>", methodName, element.generateDSLWithSameValueMethodName());
        this.javadoc = javadoc;
        this.matcher = matcher;
        this.element = element;
    }

    public String getJavaDocDescription() {
        return this.javadoc;
    }

    public String getMatcher() {
        return this.matcher;
    }

    private Supplier<DSLMethod> onlyWithSameValue(Supplier<DSLMethod> input) {
        return () -> {
            if (this.element.hasWithSameValue()) {
                return (DSLMethod)input.get();
            }
            this.element.printWarningMessage("Unable to generate ArrayContaining ; The target class doesn't support the WithSameValue() matcher");
            return null;
        };
    }

    @Override
    public Collection<Supplier<DSLMethod>> asSuppliers() {
        return Arrays.asList(this.onlyWithSameValue(this::generateArrayContains1), this.onlyWithSameValue(this::generateArrayContains2), this.onlyWithSameValue(this::generateArrayContains3), this.onlyWithSameValue(this::generateArrayContainsN));
    }

    public DSLMethod generateArrayContains1() {
        return this.generateSimpleDSLMethodFor(new String[]{this.getJavaDocDescription(), "@param first the element contained inside the target array", "@return the Matcher."}, this.getMatcher(), "first");
    }

    public DSLMethod generateArrayContains2() {
        return this.generateSimpleDSLMethodFor(new String[]{this.getJavaDocDescription(), "@param first the element contained inside the target array", "@param second the second element contained inside the target array", "@return the Matcher."}, this.getMatcher(), "first", "second");
    }

    public DSLMethod generateArrayContains3() {
        return this.generateSimpleDSLMethodFor(new String[]{this.getJavaDocDescription(), "@param first the element contained inside the target array", "@param second the second element contained inside the target array", "@param third the third element contained inside the target array", "@return the Matcher."}, this.getMatcher(), "first", "second", "third");
    }

    public DSLMethod generateArrayContainsN() {
        return DSLMethod.of(this.returnType + " " + this.methodName).withArguments(this.getSeveralParameter(true, "first", "second", "third", "last")).withImplementation(this.generateSeveralWithImplementation(this.getMatcher(), "first", "second", "third")).withJavadoc(this.getJavaDocDescription(), "@param first the first element contained inside the target array", "@param second the second element contained inside the target array", "@param third the third element contained inside the target array", "@param last the next element", "@return the Matcher.");
    }
}

