/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.helper;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.common.RessourceLoaderHelper;
import ch.powerunit.extensions.matchers.provideprocessor.Matchable;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.lang.DSLMethodArgument;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;

public final class ProvidesMatchersWithSameValueHelper {
    private static final String HAS_SAME_VALUE_IGNORE_CYCLE = RessourceLoaderHelper.loadRessource(ProvidesMatchersWithSameValueHelper.class, "DSLHasSameValueIgnoreAndCycle.txt");
    private static final String JAVADOC_OTHER = "other the other object to be used as a reference.";
    private static final String JAVDOC_PREVIOUS = "previous the previous object of the call stack of matcher.";
    private static final String JAVADOC_IGNORE = "ignoredFields fields name that must be ignored.";
    private static final String JAVADOC_POSTPROCESSOR = "postProcessor Function to be applied to modify, if necessary, the matchers.";
    private static final String JAVADOC_OTHER_IGNORE = "other the other object to be used as a reference.\nignoredFields fields name that must be ignored.";
    private static final String JAVADOC_OTHER_IGNORE_POSTPROCESSOR = "other the other object to be used as a reference.\nignoredFields fields name that must be ignored.\npostProcessor Function to be applied to modify, if necessary, the matchers.";
    private static final String JAVADOC_OTHER_PREVIOUS_IGNORE_POST = "other the other object to be used as a reference.\nprevious the previous object of the call stack of matcher.\nignoredFields fields name that must be ignored.\npostProcessor Function to be applied to modify, if necessary, the matchers.";

    private ProvidesMatchersWithSameValueHelper() {
    }

    private static DSLMethod generateWithSameValueWithParentMatcherIgnoreAndCycle(ProvidesMatchersAnnotatedElementMirror target, boolean hasSuper) {
        return ProvidesMatchersWithSameValueHelper.generateHasSameValueDeclaration(target).addOneArgument(target.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), "other").addOneArgument("java.util.Set<java.lang.Object>", "previous").addOneArgument("java.util.function.BiFunction<org.hamcrest.Matcher<?>,java.lang.Object,org.hamcrest.Matcher<?>>", "postProcessor").addOneArgument("String...", "ignoredFields").withImplementation(Arrays.asList(String.format(HAS_SAME_VALUE_IGNORE_CYCLE, target.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent(), target.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent(), ProvidesMatchersWithSameValueHelper.generateParentMatcher(target, hasSuper), ProvidesMatchersWithSameValueHelper.copyFields(target), target.getSimpleNameOfGeneratedInterfaceMatcher()).split("\n"))).withJavadoc(target.generateDefaultJavaDocWithoutDSLStarter(Optional.of(JAVADOC_OTHER_PREVIOUS_IGNORE_POST), "the DSL matcher", false));
    }

    private static String generateParentMatcher(ProvidesMatchersAnnotatedElementMirror target, boolean hasSuper) {
        return hasSuper ? target.getParentMirror().map(p -> "(" + p.getFullyQualifiedNameOfGeneratedClass() + "." + p.getSimpleNameOfGeneratedInterfaceMatcher() + ")java.util.Objects.requireNonNull(postProcessor,\"postProcessor can't be null\").apply(" + p.getWithSameValue(false) + "(other" + (p.supportSameValueWithParentPostPrecessor() ? ",postProcessor" : "") + (p.supportIgnore() ? ",ignoredFields" : "") + "),other)").orElse("org.hamcrest.Matchers.anything()") : "";
    }

    private static String copyFields(ProvidesMatchersAnnotatedElementMirror target) {
        return target.getFields().stream().flatMap(f -> Arrays.stream(ProvidesMatchersWithSameValueHelper.copyField(f).split("\n"))).collect(Collectors.joining("\n"));
    }

    private static String copyField(AbstractFieldDescription f) {
        String args = f.getTargetAsMatchable().filter(Matchable::supportCycleDetectionV1).map(x -> ",nPrevious" + (x.supportSameValueWithParentPostPrecessor() ? ",postProcessor" : "") + ",localIgnored").orElse(",localIgnored");
        return String.format("if(!ignored.contains(\"%1$s\")) {\n  String localIgnored[] = ignored.stream().filter(s->s.startsWith(\"%1$s.\")).map(s->s.replaceFirst(\"%1$s\\\\.\",\"\")).toArray(String[]::new);\n%2$s\n}", f.getFieldName(), CommonUtils.addPrefix("  ", f.getFieldCopy("m", "other", args)));
    }

    private static DSLMethod generateWithSameValueWithParentMatcherIgnoreAndPostProcessor(ProvidesMatchersAnnotatedElementMirror target) {
        return ProvidesMatchersWithSameValueHelper.generateHasSameValueDeclaration(target).addOneArgument(target.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), "other").addOneArgument("java.util.function.BiFunction<org.hamcrest.Matcher<?>,java.lang.Object,org.hamcrest.Matcher<?>>", "postProcessor").addOneArgument("String...", "ignoredFields").withImplementation(ProvidesMatchersWithSameValueHelper.generateReturnOther(target, "postProcessor,ignoredFields")).withJavadoc(target.generateDefaultJavaDocWithoutDSLStarter(Optional.of(JAVADOC_OTHER_IGNORE_POSTPROCESSOR), "the DSL matcher", false));
    }

    private static DSLMethod generateWithSameValueWithParentMatcherIgnore(ProvidesMatchersAnnotatedElementMirror target) {
        return ProvidesMatchersWithSameValueHelper.generateHasSameValueDeclaration(target).addOneArgument(target.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), "other").addOneArgument("String...", "ignoredFields").withImplementation(ProvidesMatchersWithSameValueHelper.generateReturnOther(target, "(m,o)->m,ignoredFields")).withJavadoc(target.generateDefaultJavaDocWithoutDSLStarter(Optional.of(JAVADOC_OTHER_IGNORE), "the DSL matcher", false));
    }

    private static DSLMethod generateWithSameValueWithParentMatcherAndNoIgnore(ProvidesMatchersAnnotatedElementMirror target) {
        return ProvidesMatchersWithSameValueHelper.generateHasSameValueDeclaration(target).withOneArgument(target.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), "other").withImplementation(ProvidesMatchersWithSameValueHelper.generateReturnOther(target, "(m,o)->m,new String[]{}")).withJavadoc(target.generateDefaultJavaDocWithoutDSLStarter(Optional.of(JAVADOC_OTHER), "the DSL matcher", false));
    }

    private static String generateReturnOther(ProvidesMatchersAnnotatedElementMirror target, String complement) {
        return String.format("return %1$s(other,java.util.Collections.emptySet(),%2$s);", target.getMethodNameDSLWithSameValue(), complement);
    }

    private static DSLMethodArgument generateHasSameValueDeclaration(ProvidesMatchersAnnotatedElementMirror target) {
        return DSLMethod.of(String.format("%1$s %2$s.%3$s %4$s", target.getFullGeneric(), target.getFullyQualifiedNameOfGeneratedClass(), target.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent(), target.getMethodNameDSLWithSameValue()));
    }

    private static boolean isWeakAllowed(ProvidesMatchersAnnotatedElementMirror target) {
        return target.getRealAnnotation().allowWeakWithSameValue();
    }

    private static void logWeak(ProvidesMatchersAnnotatedElementMirror target) {
        Optional<AnnotationMirror> am = target.getAnnotationMirror();
        Optional<AnnotationValue> av = am.map(a -> a.getElementValues().entrySet().stream().filter(kv -> ((ExecutableElement)kv.getKey()).getSimpleName().toString().equals("allowWeakWithSameValue")).map(Map.Entry::getValue).findAny().orElse(null));
        target.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "This class use the option allowWeakWithSameValue and a weak WithSameValue is detected. The generated WithSameValue DSL may not be able to fully control all the field of this class", (Element)target.getElement(), am.orElse(null), av.orElse(null));
    }

    public static Collection<DSLMethod> generateParentValueDSLStarter(ProvidesMatchersAnnotatedElementMirror target) {
        return target.getParentMirror().map(parentMirror -> Arrays.asList(ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnoreAndCycle(target, true), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnoreAndPostProcessor(target), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnore(target), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherAndNoIgnore(target))).orElseGet(() -> {
            if (ProvidesMatchersWithSameValueHelper.isWeakAllowed(target)) {
                ProvidesMatchersWithSameValueHelper.logWeak(target);
                return Arrays.asList(ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnoreAndCycle(target, true), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnoreAndPostProcessor(target), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnore(target), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherAndNoIgnore(target));
            }
            return Collections.emptyList();
        });
    }

    public static Collection<DSLMethod> generateNoParentValueDSLStarter(ProvidesMatchersAnnotatedElementMirror target) {
        return Arrays.asList(ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnoreAndCycle(target, false), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnoreAndPostProcessor(target), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherIgnore(target), ProvidesMatchersWithSameValueHelper.generateWithSameValueWithParentMatcherAndNoIgnore(target));
    }
}

