/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.common;

import ch.powerunit.extensions.matchers.common.AbstractRoundMirrorReferenceToProcessingEnv;
import ch.powerunit.extensions.matchers.common.AbstractRoundMirrorSupport;
import ch.powerunit.extensions.matchers.common.ElementHelper;
import ch.powerunit.extensions.matchers.common.ProcessingEnvironmentHelper;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractElementMirror<E extends Element, R extends AbstractRoundMirrorReferenceToProcessingEnv>
implements AbstractRoundMirrorSupport<R>,
ElementHelper,
ProcessingEnvironmentHelper {
    protected final R roundMirror;
    protected final E element;
    protected final Optional<String> doc;
    protected final Optional<TypeElement> annotation;

    public AbstractElementMirror(String annotationType, R roundMirror, E element) {
        this.roundMirror = roundMirror;
        this.element = element;
        this.doc = Optional.ofNullable(roundMirror.getElementUtils().getDocComment((Element)element));
        this.annotation = Optional.ofNullable(roundMirror.getElementUtils().getTypeElement(annotationType));
    }

    @Override
    public R getRoundMirror() {
        return this.roundMirror;
    }

    public E getElement() {
        return this.element;
    }

    public String getParamComment() {
        return this.doc.map(AbstractElementMirror::extractParamCommentFromJavadoc).orElse(" * \n");
    }

    public Optional<AnnotationMirror> getAnnotationMirror() {
        return this.annotation.map(a -> this.getTypeUtils().getDeclaredType((TypeElement)a, new TypeMirror[0])).map(a -> this.element.getAnnotationMirrors().stream().filter(m -> this.getTypeUtils().isSameType((TypeMirror)a, m.getAnnotationType())).findAny().orElse(null));
    }

    @Override
    public ProcessingEnvironment getProcessingEnv() {
        return ((AbstractRoundMirrorReferenceToProcessingEnv)this.roundMirror).getProcessingEnv();
    }

    private static String extractParamCommentFromJavadoc(String docComment) {
        boolean insideParam = false;
        StringBuilder sb = new StringBuilder(" * \n");
        for (String line : docComment.split("\\R")) {
            if (insideParam && line.matches("^\\s*@.*$")) {
                insideParam = false;
            }
            if (line.matches("^\\s*@param.*$")) {
                insideParam = true;
            }
            if (!insideParam) continue;
            sb.append(" *").append(line).append("\n");
        }
        return sb.toString();
    }
}

