/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.common;

import ch.powerunit.extensions.matchers.common.lang.ListJoiningAround;
import ch.powerunit.extensions.matchers.common.lang.ListJoiningDelimiter;
import ch.powerunit.extensions.matchers.common.lang.ListJoiningMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public final class ListJoining<E> {
    public static final ListJoining<Object> COMMA_SEPARATED = ListJoining.accepting(Object.class).withToStringMapper().withCommaDelimiter().withoutSuffixAndPrefix();
    public static final ListJoining<Object> NL_SEPARATED = ListJoining.accepting(Object.class).withToStringMapper().withDelimiter("\n").withoutSuffixAndPrefix();
    private final Function<E, String> mapper;
    private final String delimiter;
    private final UnaryOperator<String> finalizer;

    public static <E> ListJoining<E> nlSeparated() {
        return NL_SEPARATED;
    }

    public static <E> ListJoining<E> commaSeparated() {
        return COMMA_SEPARATED;
    }

    public static <E> ListJoining<E> commaSeparated(Function<E, String> mapper) {
        return ListJoining.joinWithMapper(mapper).withCommaDelimiter().withoutSuffixAndPrefix();
    }

    public static <E> ListJoiningMapper<E> accepting(Class<E> clazz) {
        return new Builder();
    }

    public static <E> ListJoiningDelimiter<E> joinWithMapper(Function<E, String> mapper) {
        return new Builder<E>().withMapper(mapper);
    }

    public static <E> ListJoining<E> joinWithMapperAndDelimiter(Function<E, String> mapper, String delimiter) {
        return new Builder<E>().withMapper(mapper).withDelimiter(delimiter).withoutSuffixAndPrefix();
    }

    public ListJoining(Function<E, String> mapper, String delimiter, UnaryOperator<String> finalizer) {
        this.mapper = mapper;
        this.delimiter = delimiter;
        this.finalizer = finalizer;
    }

    public String asString(Collection<E> input) {
        return (String)Objects.requireNonNull(input, "input can't be null").stream().map(this.mapper).collect(Collectors.collectingAndThen(Collectors.joining(this.delimiter), this.finalizer));
    }

    public String asString(E ... input) {
        return this.asString(Arrays.asList(input));
    }

    public static class Builder<E>
    implements ListJoiningAround<E>,
    ListJoiningDelimiter<E>,
    ListJoiningMapper<E> {
        private Function<E, String> mapper;
        private String delimiter;

        @Override
        public ListJoiningDelimiter<E> withMapper(Function<E, String> mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper can't be null");
            return this;
        }

        @Override
        public ListJoiningAround<E> withDelimiter(String delimiter) {
            this.delimiter = Objects.requireNonNull(delimiter, "delimiter can't be null");
            return this;
        }

        @Override
        public ListJoining<E> withFinalFunction(UnaryOperator<String> finalizer) {
            return new ListJoining<E>(this.mapper, this.delimiter, finalizer);
        }
    }
}

