/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.provideprocessor.Matchable;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.DefaultFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public class OptionalFieldDescription
extends DefaultFieldDescription {
    public OptionalFieldDescription(ProvidesMatchersAnnotatedElementData containingElementMirror, FieldDescriptionMirror mirror) {
        super(containingElementMirror, mirror);
    }

    @Override
    protected Collection<FieldDSLMethod> getSpecificFieldDslMethodFor() {
        ArrayList<FieldDSLMethod> dsl = new ArrayList<FieldDSLMethod>();
        dsl.addAll(this.getPresentDSL());
        dsl.addAll(this.getAbsentDSL());
        return dsl;
    }

    private Collection<FieldDSLMethod> getPresentDSL() {
        String fieldType = this.getFieldType();
        return Arrays.asList(this.getDslMethodBuilder().withSuffixDeclarationJavadocAndDefault("IsPresent", "with a present optional", "new org.hamcrest.CustomTypeSafeMatcher<" + fieldType + ">(\"optional is present\"){ public boolean matchesSafely(" + fieldType + " o) {return o.isPresent();}}"), this.getDslMethodBuilder().withDeclaration("IsPresentAndIs", this.generic + " value").withJavaDoc("with a present optional having a specific value", "value the value the optional must have").havingDefault("new org.hamcrest.TypeSafeMatcher<" + fieldType + ">(){ public boolean matchesSafely(" + fieldType + " o) {return o.isPresent() && o.get().equals(value);} public void describeTo(org.hamcrest.Description description) {description.appendText(\"optional is present and is \").appendValue(value);}}"), this.getDslMethodBuilder().withDeclaration("IsPresentAndIs", "org.hamcrest.Matcher<" + this.generic + "> matcher").withJavaDoc("with a present optional matching a specified matcher", "matcher the matcher that must accept the optional value").havingDefault("new org.hamcrest.TypeSafeMatcher<" + fieldType + ">(){ public boolean matchesSafely(" + fieldType + " o) {return o.isPresent() && matcher.matches(o.get());} public void describeTo(org.hamcrest.Description description) {description.appendText(\"optional is present and [\").appendDescriptionOf(matcher).appendText(\"]\");}}"));
    }

    private Collection<FieldDSLMethod> getAbsentDSL() {
        String fieldType = this.getFieldType();
        return Arrays.asList(this.getDslMethodBuilder().withSuffixDeclarationJavadocAndDefault("IsNotPresent", "with a not present optional", "new org.hamcrest.CustomTypeSafeMatcher<" + fieldType + ">(\"optional is not present\"){ public boolean matchesSafely(" + fieldType + " o) {return !o.isPresent();}}"), this.getDslMethodBuilder().withSuffixDeclarationJavadocAndDefault("IsAbsent", "with an absent optional", "new org.hamcrest.CustomTypeSafeMatcher<" + fieldType + ">(\"optional is not present\"){ public boolean matchesSafely(" + fieldType + " o) {return !o.isPresent();}}"));
    }

    @Override
    public String getFieldCopy(String lhs, String rhs, String ignore) {
        if (!"".equals(this.generic)) {
            return this.getFieldCopyForOptional(lhs, rhs, ignore);
        }
        return super.getFieldCopy(lhs, rhs, ignore);
    }

    public String getFieldCopyForOptional(String lhs, String rhs, String paramForHasSameValue) {
        String fieldAccessor = this.getFieldAccessor();
        String fieldName = this.getFieldName();
        return "if(" + rhs + "." + fieldAccessor + "==null) {\n  " + lhs + "." + fieldName + "(" + "org.hamcrest.Matchers" + ".nullValue());\n} else if (!" + rhs + "." + fieldAccessor + ".isPresent()) {\n  " + lhs + "." + fieldName + "IsAbsent();\n} else {\n  " + lhs + "." + fieldName + "IsPresentAndIs(" + this.generateMatcherBuilderReferenceFor(this.generic, rhs + "." + fieldAccessor + ".get()", paramForHasSameValue) + ");\n}";
    }

    public String generateMatcherBuilderReferenceFor(String generic, String accessor, String paramForHasSameValue) {
        return Optional.ofNullable(this.getByName(generic)).filter(Matchable::hasWithSameValue).map(t -> t.getWithSameValue(false) + "(" + accessor + (t.supportIgnore() ? paramForHasSameValue : "") + ")").orElse("org.hamcrest.Matchers.is(" + accessor + ")");
    }
}

