/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.AbstractSimpleElementVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirrorSupport;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

class ProvidesMatchersElementVisitor
extends AbstractSimpleElementVisitor<Optional<TypeElement>, Void, RoundMirror>
implements RoundMirrorSupport {
    public ProvidesMatchersElementVisitor(RoundMirror roundMirror) {
        super(roundMirror);
    }

    @Override
    public Optional<TypeElement> visitType(TypeElement e, Void p) {
        switch (e.getKind()) {
            case ENUM: {
                this.errorForType(e, "enum");
                return Optional.empty();
            }
            case INTERFACE: {
                this.errorForType(e, "interface");
                return Optional.empty();
            }
        }
        return Optional.of(e);
    }

    @Override
    protected Optional<TypeElement> defaultAction(Element e, Void p) {
        this.errorForType(e, "unexpected element");
        return Optional.empty();
    }

    private void errorForType(Element e, String type) {
        this.getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "The annotation `ProvideMatchers` is used on an " + type + ", which is not supported. Since version 0.2.0 of powerunit-extension-matchers this is considered as an error.", e, ((RoundMirror)this.support).getProvideMatchersAnnotation(e));
    }
}

