/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.common.FileObjectHelper;
import ch.powerunit.extensions.matchers.common.ListJoining;
import ch.powerunit.extensions.matchers.common.RessourceLoaderHelper;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMatcherMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.helper.ProvidesMatchersWithSameValueHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class ProvidesMatchersAnnotatedElementMirror
extends ProvidesMatchersAnnotatedElementMatcherMirror {
    private final Collection<Supplier<Collection<DSLMethod>>> dslProvider;
    private static final String MATCHER_FORMAT = RessourceLoaderHelper.loadRessource(ProvidesMatchersAnnotatedElementMirror.class, "Matchers.txt");
    private static final String POSTPROCESSOR_FORMAT = CommonUtils.addPrefix("  ", RessourceLoaderHelper.loadRessource(ProvidesMatchersAnnotatedElementMirror.class, "PostProcessor.txt"));
    private static final ListJoining<DSLMethod> JOIN_DSL_METHOD = ListJoining.joinWithMapperAndDelimiter(m -> CommonUtils.addPrefix("  ", m.asStaticImplementation()), "\n");

    private static Supplier<Collection<DSLMethod>> asCollection(Supplier<DSLMethod> input) {
        return () -> Collections.singletonList((DSLMethod)input.get());
    }

    public ProvidesMatchersAnnotatedElementMirror(TypeElement typeElement, RoundMirror roundMirror) {
        super(typeElement, roundMirror);
        ArrayList<Supplier> tmp = new ArrayList<Supplier>(Arrays.asList(ProvidesMatchersAnnotatedElementMirror.asCollection(this::generateDefaultDSLStarter), ProvidesMatchersAnnotatedElementMirror.asCollection(this::generateDefaultForChainingDSLStarter), ProvidesMatchersAnnotatedElementMirror.asCollection(this::generateMatcherClassMethod)));
        if (this.hasSuperClass()) {
            tmp.add(ProvidesMatchersAnnotatedElementMirror.asCollection(this::generateParentDSLStarter));
            tmp.add(() -> ProvidesMatchersWithSameValueHelper.generateParentValueDSLStarter(this));
            if (((TypeElement)roundMirror.getTypeUtils().asElement(((TypeElement)this.element).getSuperclass())).getTypeParameters().isEmpty()) {
                tmp.add(ProvidesMatchersAnnotatedElementMirror.asCollection(this::generateParentInSameRoundWithChaningDSLStarter));
            }
        } else {
            tmp.add(() -> ProvidesMatchersWithSameValueHelper.generateNoParentValueDSLStarter(this));
        }
        tmp.addAll(Optional.ofNullable(this.getDSLExtension()).orElseGet(Collections::emptyList).stream().map(t -> t.getDSLMethodFor(() -> this)).flatMap(Collection::stream).map(ProvidesMatchersAnnotatedElementMirror::asCollection).toList());
        tmp.addAll(roundMirror.getDSLMethodFor(() -> this).stream().map(ProvidesMatchersAnnotatedElementMirror::asCollection).toList());
        this.dslProvider = Collections.unmodifiableList(tmp);
    }

    public Collection<DSLMethod> process() {
        Element te = this.element;
        return FileObjectHelper.processFileWithIOExceptionAndResult(() -> this.getFiler().createSourceFile(this.getFullyQualifiedNameOfGeneratedClass(), te), jfo -> new Formatter(new PrintWriter(jfo.openWriter())), output -> {
            Collection<DSLMethod> tmp = this.generateDSLStarter();
            output.format(MATCHER_FORMAT, this.getPackageNameOfGeneratedClass(), this.getFullyQualifiedNameOfClassAnnotated(), CommonUtils.generateGeneratedAnnotation(ProvidesMatchersAnnotationsProcessor.class, this.comments()), this.getSimpleNameOfGeneratedClass(), this.generateMatchers(), this.generatePublicInterface(), this.generatePrivateImplementation(), JOIN_DSL_METHOD.asString(tmp), POSTPROCESSOR_FORMAT, this.generateMetadata());
            output.flush();
            if (this.isDisableGenerationOfFactory()) {
                return Collections.emptyList();
            }
            return tmp;
        }, e -> CommonUtils.traceErrorAndDump(this, e, te));
    }

    public Collection<DSLMethod> generateDSLStarter() {
        return this.dslProvider.stream().map(Supplier::get).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).toList();
    }

    public String getDefaultStarterBody(boolean withParentBuilder) {
        String targetImpl = withParentBuilder ? this.getSimpleNameOfGeneratedImplementationMatcherWithGenericParent() : this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent();
        boolean withSuper = this.hasSuperClass();
        return "return new " + targetImpl + "(" + (withSuper ? "org.hamcrest.Matchers.anything()" : "") + (withSuper && withParentBuilder ? "," : "") + (withParentBuilder ? "parentBuilder" : "") + ");";
    }

    public String generateDefaultJavaDocWithDSLStarter(Optional<String> param, String returnDescription, boolean withParent) {
        return this.generateDefaultJavaDoc(Optional.of(this.getJavadocForDSLStarter()), param, returnDescription, withParent);
    }

    public String generateDefaultJavaDocWithoutDSLStarter(Optional<String> param, String returnDescription, boolean withParent) {
        return this.generateDefaultJavaDoc(Optional.empty(), param, returnDescription, withParent);
    }

    public DSLMethod generateDefaultDSLStarter() {
        return DSLMethod.of(this.fullGeneric + " " + this.getFullyQualifiedNameOfGeneratedClass() + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent() + " " + this.methodShortClassName + "With").withImplementation(this.getDefaultStarterBody(false)).withJavadoc(this.generateDefaultJavaDocWithDSLStarter(Optional.empty(), "the DSL matcher", false));
    }

    public String getJavadocForDSLStarter() {
        return "The returned builder (which is also a Matcher), at this point accepts any object that is a " + this.getDefaultLinkForAnnotatedClass() + ".";
    }

    public DSLMethod generateDefaultForChainingDSLStarter() {
        return DSLMethod.of(this.getFullGenericParent() + " " + this.getFullyQualifiedNameOfGeneratedClass() + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericParent() + " " + this.getMethodNameDSLWithParent()).withOneArgument("_PARENT", "parentBuilder").withImplementation(this.getDefaultStarterBody(true)).withJavadoc(this.generateDefaultJavaDocWithDSLStarter(Optional.of("parentBuilder the parentBuilder."), "the DSL matcher", true));
    }

    public DSLMethod generateParentDSLStarter() {
        String mscn = this.methodShortClassName;
        String fqngc = this.getFullyQualifiedNameOfGeneratedClass();
        return DSLMethod.of(this.fullGeneric + " " + fqngc + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent() + " " + mscn + "With").withOneArgument("org.hamcrest.Matcher<? super " + (String)this.fullyQualifiedNameOfSuperClassOfClassAnnotated.get() + ">", "matcherOnParent").withImplementation("return new " + this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent() + "(matcherOnParent);").withJavadoc(this.generateDefaultJavaDocWithoutDSLStarter(Optional.of("matcherOnParent the matcher on the parent data."), "the DSL matcher", false));
    }

    public DSLMethod generateParentInSameRoundWithChaningDSLStarter() {
        String implGenericNoParent = this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent();
        return this.getParentMirror().map(parentMirror -> {
            String pmfqngc = parentMirror.getFullyQualifiedNameOfGeneratedClass();
            String parentSimpleName = parentMirror.getSimpleNameOfGeneratedInterfaceMatcher();
            return DSLMethod.of(this.fullGeneric + " " + pmfqngc + "." + parentSimpleName + this.genericForChaining + " " + this.getMethodNameDSLWithParent()).withImplementation(implGenericNoParent + " m=new " + implGenericNoParent + "(org.hamcrest.Matchers.anything());", pmfqngc + "." + parentSimpleName + " tmp = " + pmfqngc + "." + parentMirror.getMethodNameDSLWithParent() + "(m);", "m._parent = new SuperClassMatcher(tmp);", "return tmp;").withJavadoc(this.generateDefaultJavaDoc(Optional.empty(), Optional.empty(), "the DSL matcher", false));
        }).orElse(null);
    }

    public DSLMethod generateMatcherClassMethod() {
        return DSLMethod.of(this.getFullGenericParent() + " Class<" + this.getFullyQualifiedNameOfGeneratedClass() + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericParent() + "> " + this.getMethodShortClassName() + "MatcherClass").withoutArgument().withImplementation("return (Class)" + this.getSimpleNameOfGeneratedInterfaceMatcher() + ".class;").withJavadoc("/**\n * Helper method to retrieve the Class of the matcher interface.\n * @return the class.\n */\n");
    }
}

