/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.AbstractElementMirror;
import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.common.FactoryHelper;
import ch.powerunit.extensions.matchers.common.FileObjectHelper;
import ch.powerunit.extensions.matchers.common.RessourceLoaderHelper;
import ch.powerunit.extensions.matchers.provideprocessor.ProvideMatchersMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"ch.powerunit.extensions.matchers.api.ProvideMatchers", "ch.powerunit.extensions.matchers.api.IgnoreInMatcher", "ch.powerunit.extensions.matchers.api.AddToMatcher", "ch.powerunit.extensions.matchers.api.AddToMatchers"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor.factory"})
public class ProvidesMatchersAnnotationsProcessor
extends AbstractProcessor {
    private Optional<String> factoryParam = null;
    private List<String> factories = new ArrayList<String>();
    private List<Element> allSourceElements = new ArrayList<Element>();
    private static final List<String> POSTPROCESSOR_FORMAT = Collections.unmodifiableList(Arrays.asList(CommonUtils.addPrefix("  ", RessourceLoaderHelper.loadRessource(ProvidesMatchersAnnotatedElementMirror.class, "PostProcessor.txt")).split("\n")));

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.factoryParam = Optional.ofNullable(processingEnv.getOptions().get(ProvidesMatchersAnnotationsProcessor.class.getName() + ".factory"));
        if (processingEnv.getSourceVersion() != null && processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_17) < 0) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The source version " + processingEnv.getSourceVersion() + " is not supported by this powerunit-extensions-matchers.");
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.processRound(roundEnv);
        } else {
            this.processFinalRound();
        }
        return true;
    }

    private void processRound(RoundEnvironment roundEnv) {
        Collection<ProvidesMatchersAnnotatedElementMirror> alias = new RoundMirror(roundEnv, this.processingEnv).parse();
        this.factories.addAll(alias.stream().collect(Collectors.toMap(ProvideMatchersMirror::getFullyQualifiedNameOfGeneratedClass, ProvidesMatchersAnnotatedElementMirror::process)).entrySet().stream().map(e -> ((Collection)e.getValue()).stream().map(m -> CommonUtils.addPrefix("  ", m.asDefaultReference((String)e.getKey()))).collect(Collectors.joining("\n"))).toList());
        alias.stream().map(AbstractElementMirror::getElement).forEach(this.allSourceElements::add);
    }

    private void processFinalRound() {
        this.factoryParam.ifPresent(this::processFactory);
    }

    private void processFactory(String factory) {
        FileObjectHelper.processFileWithIOException(() -> this.processingEnv.getFiler().createSourceFile(factory, this.allSourceElements.toArray(new Element[0])), jfo -> new PrintWriter(jfo.openWriter()), wjfo -> FactoryHelper.generateFactoryClass(wjfo, ProvidesMatchersAnnotationsProcessor.class, factory.replaceAll("\\.[^.]+$", ""), factory.replaceAll("^([^.]+\\.)*", ""), () -> Stream.concat(this.factories.stream(), POSTPROCESSOR_FORMAT.stream())), e -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class `" + factory + "`, because of " + e.getMessage()));
    }
}

