/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.AbstractSimpleElementVisitor;
import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.provideprocessor.NameExtractorVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMatcherMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMetaData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionProvider;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class ProvidesMatchersSubElementVisitor
extends AbstractSimpleElementVisitor<Optional<AbstractFieldDescription>, ProvidesMatchersAnnotatedElementMatcherMirror, RoundMirror> {
    private final Function<Element, Boolean> removeFromIgnoreList = roundMirror::removeFromIgnoreList;
    private final NameExtractorVisitor extractNameVisitor;

    public ProvidesMatchersSubElementVisitor(RoundMirror roundMirror) {
        super(roundMirror);
        this.extractNameVisitor = new NameExtractorVisitor(roundMirror);
    }

    public Optional<AbstractFieldDescription> removeIfNeededAndThenReturn(Optional<AbstractFieldDescription> fieldDescription) {
        fieldDescription.map(FieldDescriptionMetaData::getFieldElement).ifPresent(this.removeFromIgnoreList::apply);
        return fieldDescription;
    }

    @Override
    public Optional<AbstractFieldDescription> visitVariable(VariableElement e, ProvidesMatchersAnnotatedElementMatcherMirror p) {
        if (ElementKind.RECORD.equals((Object)e.getEnclosingElement().getKind())) {
            this.removeFromIgnoreList.apply(e);
            return Optional.empty();
        }
        if (this.isPublic(e) && !this.isStatic(e)) {
            String fieldName = this.getSimpleName(e);
            return this.createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(e, p, fieldName);
        }
        this.generateIfNeededErrorForNotSupportedElementAndRemoveIt("Check that this field is public and not static", e);
        return Optional.empty();
    }

    @Override
    public Optional<AbstractFieldDescription> visitExecutable(ExecutableElement e, ProvidesMatchersAnnotatedElementMatcherMirror p) {
        if (this.isPublic(e) && e.getParameters().size() == 0 && !this.isStatic(e)) {
            String simpleName = this.getSimpleName(e);
            if (simpleName.matches("^((get)|(is)).*")) {
                return this.visiteExecutableGet(e, "^(get)|(is)", p);
            }
            if (ElementKind.RECORD.equals((Object)e.getEnclosingElement().getKind())) {
                this.removeFromIgnoreList.apply(e);
                return Optional.empty();
            }
        }
        this.generateIfNeededErrorForNotSupportedElementAndRemoveIt("Check that this method is public, doesn't have any parameter and is named isXXX or getXXX", e);
        return Optional.empty();
    }

    @Override
    public Optional<AbstractFieldDescription> visitRecordComponent(RecordComponentElement e, ProvidesMatchersAnnotatedElementMatcherMirror p) {
        return this.createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(e, p, this.getSimpleName(e));
    }

    private void generateIfNeededErrorForNotSupportedElementAndRemoveIt(String description, Element e) {
        if (this.removeFromIgnoreList.apply(e).booleanValue()) {
            this.getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "One of the annotation is not supported as this location ; " + description + ". Since version 0.2.0 of powerunit-extension-matchers this is considered as an error.", e);
        }
    }

    private Optional<AbstractFieldDescription> visiteExecutableGet(ExecutableElement e, String prefix, ProvidesMatchersAnnotatedElementMatcherMirror p) {
        return this.createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(e, p, CommonUtils.asStandardMethodName(this.getSimpleName(e).replaceFirst(prefix, "")));
    }

    public Optional<AbstractFieldDescription> createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(Element e, ProvidesMatchersAnnotatedElementMatcherMirror p, String fieldName) {
        TypeMirror typeMirror;
        if (e instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)e;
            typeMirror = ee.getReturnType();
        } else {
            typeMirror = e.asType();
        }
        return this.removeIfNeededAndThenReturn(typeMirror.accept(this.extractNameVisitor, false).map(f -> FieldDescriptionProvider.of(() -> p, new FieldDescriptionMirror(() -> p, fieldName, (String)f, e))));
    }

    @Override
    protected Optional<AbstractFieldDescription> defaultAction(Element e, ProvidesMatchersAnnotatedElementMatcherMirror p) {
        return Optional.empty();
    }
}

