/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.extension;

import ch.powerunit.extensions.matchers.api.ComplementaryExpositionMethod;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.extension.AbstractDSLExtensionSupplier;
import ch.powerunit.extensions.matchers.provideprocessor.extension.DSLExtension;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class HasItemsExtension
implements DSLExtension {
    public static final String CONTAINS_MATCHER = "org.hamcrest.Matchers.hasItems";
    private static final String JAVADOC_DESCRIPTION = "Generate a hasItems matcher for this Object.";

    @Override
    public ComplementaryExpositionMethod supportedEnum() {
        return ComplementaryExpositionMethod.HAS_ITEMS;
    }

    @Override
    public Collection<Supplier<DSLMethod>> getDSLMethodFor(ProvidesMatchersAnnotatedElementData element) {
        return new HasItemSupplier(element).asSuppliers();
    }

    public class HasItemSupplier
    extends AbstractDSLExtensionSupplier {
        private final ProvidesMatchersAnnotatedElementData element;

        public HasItemSupplier(ProvidesMatchersAnnotatedElementData element) {
            super(element.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), element.getFullGeneric() + " org.hamcrest.Matcher<java.lang.Iterable<" + element.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric() + ">>", element.generateDSLMethodName("hasItems"), element.generateDSLWithSameValueMethodName());
            this.element = element;
        }

        @Override
        public Collection<Supplier<DSLMethod>> asSuppliers() {
            return Arrays.asList(this::generateContainsN);
        }

        public DSLMethod generateContainsN() {
            if (this.element.hasWithSameValue()) {
                return DSLMethod.of(this.returnType + " " + this.methodName).withArguments(this.getSeveralParameter(true, "item")).withImplementation("return org.hamcrest.Matchers.hasItems(java.util.Arrays.stream(item).map(v->" + this.targetMethodName + "(v)).collect(java.util.stream.Collectors.toList()).toArray(new org.hamcrest.Matcher[0]));").withJavadoc(HasItemsExtension.JAVADOC_DESCRIPTION, "@param item the item to be matched", "@return the Matcher.");
            }
            this.element.printWarningMessage("Unable to apply the " + HasItemsExtension.this.supportedEnum().name() + " extension ; The target class doesn't support the WithSameValue() matcher");
            return null;
        }
    }
}

