/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.provideprocessor.Matchable;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescriptionContainerMetaData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.IgnoreFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.helper.FeatureMatcher;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public abstract class FieldDescriptionMetaData
extends AbstractFieldDescriptionContainerMetaData {
    public static final String SEE_TEXT_FOR_IS_MATCHER = "org.hamcrest.Matchers#is(java.lang.Object)";
    public static final String SEE_TEXT_FOR_HAMCREST_MATCHER = "org.hamcrest.Matchers The main class from hamcrest that provides default matchers.";
    public static final String MATCHERS = "org.hamcrest.Matchers";
    protected final String generic;
    protected final String defaultReturnMethod;
    protected final FieldDescriptionMirror mirror;

    public static final String computeGenericInformation(TypeMirror fieldTypeMirror) {
        if (fieldTypeMirror instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)fieldTypeMirror;
            return dt.getTypeArguments().stream().map(Object::toString).map(s -> s.replaceAll("@[^ ]+ ", "")).collect(Collectors.joining(","));
        }
        return "";
    }

    public FieldDescriptionMetaData(ProvidesMatchersAnnotatedElementData containingElementMirror, FieldDescriptionMirror mirror) {
        super(containingElementMirror);
        this.mirror = mirror;
        TypeMirror fieldTypeMirror = mirror.getFieldTypeMirror();
        this.defaultReturnMethod = containingElementMirror.getDefaultReturnMethod();
        this.generic = FieldDescriptionMetaData.computeGenericInformation(fieldTypeMirror);
    }

    public String getMatcherForField() {
        return new FeatureMatcher(this.mirror.getMethodFieldName(), this.containingElementMirror.getFullGeneric(), this.getFullyQualifiedNameEnclosingClassOfField(), this.containingElementMirror.getGeneric(), this.getFieldType(), this.getFieldName(), "actual." + this.getFieldAccessor()).toString();
    }

    public String getFieldCopy(String lhs, String rhs, String ignore) {
        return this.getTargetAsMatchable().filter(a -> this.mirror.getFieldTypeAsTypeElement().getTypeParameters().isEmpty()).filter(Matchable::hasWithSameValue).map(p -> String.format("%1$s.%6$s(%2$s.%3$s == null ? org.hamcrest.Matchers.nullValue() : %4$s(%2$s.%3$s%5$s));", lhs, rhs, this.getFieldAccessor(), p.getWithSameValue(false), p.supportIgnore() ? ignore : "", this.getFieldName())).orElseGet(() -> String.format("%1$s.%4$s((org.hamcrest.Matcher)org.hamcrest.Matchers.is((java.lang.Object)%2$s.%3$s));", lhs, rhs, this.getFieldAccessor(), this.getFieldName()));
    }

    public String asMatchesSafely() {
        return String.format("if(!%1$s.matches(actual)) {\n  mismatchDescription.appendText(\"[\"); %1$s.describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");\n  result=false;\n}", this.getFieldName());
    }

    public String asDescribeTo() {
        return "_description.appendText(\"[\").appendDescriptionOf(this." + this.getFieldName() + ").appendText(\"]\\n\");";
    }

    public String asMatcherField() {
        return String.format("private %1$sMatcher %2$s = new %1$sMatcher(%3$s.anything(%4$s));", this.mirror.getMethodFieldName(), this.getFieldName(), MATCHERS, "");
    }

    public String getFullyQualifiedNameEnclosingClassOfField() {
        return this.containingElementMirror.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher();
    }

    public String getDefaultReturnMethod() {
        return this.defaultReturnMethod;
    }

    public String getFieldAccessor() {
        return this.mirror.getFieldAccessor();
    }

    public String getFieldName() {
        return this.mirror.getFieldName();
    }

    public String getFieldType() {
        return this.mirror.getFieldType();
    }

    public Element getFieldElement() {
        return this.mirror.getFieldElement();
    }

    public FieldDescriptionMirror getMirror() {
        return this.mirror;
    }

    public Optional<Matchable> getTargetAsMatchable() {
        return this.mirror.getMatchable(this.containingElementMirror.getRoundMirror());
    }

    public String getGeneric() {
        return this.generic;
    }

    public String generateMetadata(String className) {
        return String.format("new %1$s<%9$s>(\n        %2$s,\n        %3$s,\n        %4$s,\n        %5$s,\n        %6$s,\n        %7$s,\n        \"%8$s\",\n        %9$s.class,\n        %10$s)", className, CommonUtils.toJavaSyntax(this.getFieldName()), CommonUtils.toJavaSyntax(this.getFieldType()), CommonUtils.toJavaSyntax(this.getFieldAccessor()), (String)(this.getFieldElement().getKind().equals((Object)ElementKind.FIELD) ? "o->o." : this.getFullyQualifiedNameEnclosingClassOfField() + "::") + this.getFieldAccessor().replaceAll("[()]+", ""), CommonUtils.toJavaSyntax(this.getClass().getSimpleName()), Boolean.toString(this instanceof IgnoreFieldDescription), this.getFieldElement().getKind().name(), this.getTargetAsMatchable().map(m -> m.getFullyQualifiedNameOfGeneratedClass() + ".Metadata").orElse("Void"), this.getTargetAsMatchable().map(m -> m.getFullyQualifiedNameOfGeneratedClass() + ".METADATA").orElse("null"));
    }
}

