/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.common.ElementHelper;
import ch.powerunit.extensions.matchers.provideprocessor.Matchable;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class FieldDescriptionMirror
implements ElementHelper {
    private final String fieldName;
    private final String fieldType;
    private final TypeElement fieldTypeAsTypeElement;
    private final Element fieldElement;

    public FieldDescriptionMirror(ProvidesMatchersAnnotatedElementData containingElementMirror, String fieldName, String fieldType, Element fieldElement) {
        ProcessingEnvironment processingEnv = containingElementMirror.getRoundMirror().getProcessingEnv();
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldTypeAsTypeElement = processingEnv.getElementUtils().getTypeElement(fieldType);
        this.fieldElement = fieldElement;
    }

    public String getFieldAccessor() {
        return this.getSimpleName(this.fieldElement) + (this.fieldElement instanceof ExecutableElement || this.fieldElement instanceof RecordComponentElement ? "()" : "");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getMethodFieldName() {
        return this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public Element getFieldElement() {
        return this.fieldElement;
    }

    public TypeElement getFieldTypeAsTypeElement() {
        return this.fieldTypeAsTypeElement;
    }

    public TypeMirror getFieldTypeMirror() {
        TypeMirror typeMirror;
        Element element = this.fieldElement;
        if (element instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)element;
            typeMirror = ee.getReturnType();
        } else {
            typeMirror = this.fieldElement.asType();
        }
        return typeMirror;
    }

    public Optional<Matchable> getMatchable(RoundMirror roundMirror) {
        return Optional.ofNullable(roundMirror.getByName(this.getFieldType()));
    }
}

