/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.api.IgnoreInMatcher;
import ch.powerunit.extensions.matchers.common.AbstractTypeKindVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.ArrayFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.CollectionFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.ComparableFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.DefaultFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.IgnoreFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.MapFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.OptionalFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.PrimitiveFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.StringFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.SupplierFieldDescription;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public final class FieldDescriptionProvider {
    private FieldDescriptionProvider() {
    }

    public static boolean isIgnored(FieldDescriptionMirror mirror) {
        return mirror.getFieldElement().getAnnotation(IgnoreInMatcher.class) != null;
    }

    public static AbstractFieldDescription of(ProvidesMatchersAnnotatedElementData containingElementMirror, FieldDescriptionMirror mirror) {
        TypeMirror typeMirror;
        if (FieldDescriptionProvider.isIgnored(mirror)) {
            return new IgnoreFieldDescription(containingElementMirror, mirror);
        }
        Element te = mirror.getFieldElement();
        ExtractTypeVisitor extractTypeVisitor = new ExtractTypeVisitor(containingElementMirror);
        if (te instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)te;
            typeMirror = ee.getReturnType();
        } else {
            typeMirror = te.asType();
        }
        return (AbstractFieldDescription)extractTypeVisitor.visit(typeMirror, mirror);
    }

    public static final class ExtractTypeVisitor
    extends AbstractTypeKindVisitor<AbstractFieldDescription, FieldDescriptionMirror, RoundMirror> {
        private final ProvidesMatchersAnnotatedElementData containingElementMirror;

        public ExtractTypeVisitor(ProvidesMatchersAnnotatedElementData containingElementMirror) {
            super(containingElementMirror.getRoundMirror());
            this.containingElementMirror = containingElementMirror;
        }

        private boolean isAssignable(DeclaredType t, String target) {
            ProcessingEnvironment processingEnv = this.getProcessingEnv();
            Types types = processingEnv.getTypeUtils();
            Elements elements = processingEnv.getElementUtils();
            return types.isAssignable(t, types.erasure(elements.getTypeElement(target).asType()));
        }

        @Override
        protected AbstractFieldDescription defaultAction(TypeMirror t, FieldDescriptionMirror mirror) {
            return new DefaultFieldDescription(this.containingElementMirror, mirror);
        }

        @Override
        public AbstractFieldDescription visitPrimitive(PrimitiveType t, FieldDescriptionMirror mirror) {
            return new PrimitiveFieldDescription(this.containingElementMirror, mirror);
        }

        @Override
        public AbstractFieldDescription visitArray(ArrayType t, FieldDescriptionMirror mirror) {
            return new ArrayFieldDescription(this.containingElementMirror, mirror);
        }

        @Override
        public AbstractFieldDescription visitDeclared(DeclaredType t, FieldDescriptionMirror mirror) {
            if (this.isAssignable(t, "java.util.Optional")) {
                return new OptionalFieldDescription(this.containingElementMirror, mirror);
            }
            if (this.isAssignable(t, "java.util.Map")) {
                return new MapFieldDescription(this.containingElementMirror, mirror);
            }
            if (this.isAssignable(t, "java.util.Set") || this.isAssignable(t, "java.util.List") || this.isAssignable(t, "java.util.Collection")) {
                return new CollectionFieldDescription(this.containingElementMirror, mirror);
            }
            if (this.isAssignable(t, "java.lang.String")) {
                return new StringFieldDescription(this.containingElementMirror, mirror);
            }
            if (this.isAssignable(t, "java.lang.Comparable")) {
                return new ComparableFieldDescription(this.containingElementMirror, mirror);
            }
            if (this.isAssignable(t, "java.util.function.Supplier")) {
                return new SupplierFieldDescription(this.containingElementMirror, mirror);
            }
            return new DefaultFieldDescription(this.containingElementMirror, mirror);
        }

        @Override
        public AbstractFieldDescription visitTypeVariable(TypeVariable t, FieldDescriptionMirror mirror) {
            return new DefaultFieldDescription(this.containingElementMirror, mirror);
        }

        @Override
        public AbstractFieldDescription visitUnknown(TypeMirror t, FieldDescriptionMirror mirror) {
            this.getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unsupported type element");
            return new DefaultFieldDescription(this.containingElementMirror, mirror);
        }
    }
}

