/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extension.spring.impl;

import ch.powerunit.TestContext;
import ch.powerunit.extension.spring.SpringRule;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class SpringRuleImpl
implements SpringRule {
    private ClassPathXmlApplicationContext springContext;
    private final String[] location;
    private final int autowireMode;

    public SpringRuleImpl(String[] location, int autowireMode) {
        this.location = location;
        this.autowireMode = autowireMode;
    }

    public void onStart(TestContext<Object> context) {
        this.springContext = new ClassPathXmlApplicationContext(this.location);
        this.springContext.refresh();
        this.springContext.getAutowireCapableBeanFactory().autowireBeanProperties(context.getTestSuiteObject(), this.autowireMode, true);
    }

    public void onEnd(TestContext<Object> context) {
        if (this.springContext != null && this.springContext.isActive()) {
            this.springContext.close();
        }
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.springContext;
    }
}

