/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.demo.springboot.hero;

import ch.puzzle.libpuzzle.demo.springboot.common.ApiActions;
import ch.puzzle.libpuzzle.demo.springboot.hero.Hero;
import ch.puzzle.libpuzzle.demo.springboot.hero.HeroDto;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.CreateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.DeleteAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.FindAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.ListAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.UpdateAction;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"hero"})
public class HeroController {
    private ApiActions<Hero> actions;

    public HeroController(ApiActions<Hero> actions) {
        this.actions = actions;
    }

    @GetMapping
    public ResponseEntity<List<HeroDto>> list() {
        return ((ListAction)this.actions.list()).execute(HeroDto.class);
    }

    @GetMapping(value={"{id}"})
    public ResponseEntity<HeroDto> find(@PathVariable long id) {
        return ((FindAction)this.actions.find()).by((Object)id).execute(HeroDto.class);
    }

    @PostMapping
    public ResponseEntity<HeroDto> create(@RequestBody @Valid HeroDto dto) {
        return ((CreateAction)this.actions.create()).with((Object)dto).using((Object)new Hero()).execute(HeroDto.class);
    }

    @PutMapping(value={"{id}"})
    public ResponseEntity<HeroDto> update(@PathVariable long id, @RequestBody @Valid HeroDto dto) {
        return ((UpdateAction)this.actions.update()).by((Object)id).with((Object)dto).execute(HeroDto.class);
    }

    @DeleteMapping(value={"{id}"})
    public ResponseEntity<Void> delete(@PathVariable long id) {
        return ((DeleteAction)this.actions.delete()).by((Object)id).execute();
    }
}

