/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.modelmapper.jpa;

import ch.puzzle.libpuzzle.modelmapper.jpa.ReferenceProvider;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.modelmapper.Converter;
import org.modelmapper.Provider;
import org.modelmapper.spi.MappingContext;

public class ListOfReferencesProvider<TDto, TEntity, TCollection extends Collection<TEntity>>
implements Converter<Collection<TDto>, TCollection>,
Provider<Collection<TEntity>> {
    private final ReferenceProvider<TDto, TEntity> referenceProvider;
    private final Supplier<TCollection> emptyCollectionSupplier;
    private final Collector<TEntity, ?, TCollection> collector;

    public ListOfReferencesProvider(ReferenceProvider<TDto, TEntity> referenceProvider, Collector<TEntity, ?, TCollection> collector, Supplier<TCollection> emptyCollectionSupplier) {
        this.referenceProvider = referenceProvider;
        this.collector = collector;
        this.emptyCollectionSupplier = emptyCollectionSupplier;
    }

    public TCollection get(Provider.ProvisionRequest<Collection<TEntity>> request) {
        Object source = request.getSource();
        if (!(source instanceof Collection)) {
            throw new IllegalArgumentException(String.format("Trying to provide Collection<TEntity> out of '%s'", source.getClass()));
        }
        return this.get((Collection)source);
    }

    public TCollection convert(MappingContext<Collection<TDto>, TCollection> context) {
        return this.get((Collection)context.getSource());
    }

    private TCollection get(Collection<TDto> source) {
        if (source == null) {
            return (TCollection)((Collection)this.emptyCollectionSupplier.get());
        }
        return (TCollection)((Collection)source.stream().map(this.referenceProvider::get).collect(this.collector));
    }
}

