/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.modelmapper.jpa;

import java.util.function.Function;
import javax.persistence.EntityManager;
import org.modelmapper.ModelMapper;
import org.modelmapper.Provider;

public class ReferenceProvider<TDto, TEntity>
implements Provider<TEntity> {
    private final ModelMapper mapper;
    private final EntityManager entityManager;
    private final Function<TDto, Object> idProvider;
    private final Class<TEntity> entityClass;
    private boolean update;

    public ReferenceProvider(ModelMapper mapper, EntityManager entityManager, Class<TEntity> entityClass, Function<TDto, Object> idProvider, boolean update) {
        this.mapper = mapper;
        this.entityManager = entityManager;
        this.entityClass = entityClass;
        this.idProvider = idProvider;
        this.update = update;
    }

    public TEntity get(Provider.ProvisionRequest<TEntity> request) {
        Object source = request.getSource();
        return this.get(source);
    }

    public TEntity get(TDto dto) {
        if (dto == null) {
            return null;
        }
        Object id = this.idProvider.apply(dto);
        if (id == null) {
            return (TEntity)this.mapper.map(dto, this.entityClass);
        }
        Object entity = this.entityManager.getReference(this.entityClass, id);
        if (this.update) {
            this.mapper.map(dto, entity);
        }
        return (TEntity)entity;
    }
}

