/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action;

import ch.puzzle.libpuzzle.springframework.boot.rest.IllegalActionParam;
import ch.puzzle.libpuzzle.springframework.boot.rest.mapper.DtoMapper;
import java.util.function.Supplier;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class CreateAction<TEntity> {
    private CrudRepository<TEntity, ?> repository;
    private DtoMapper mapper;
    private Supplier<Object> dtoSupplier = IllegalActionParam.missingParam(CreateAction.class, "with");
    private Supplier<TEntity> entitySupplier = IllegalActionParam.missingParam(CreateAction.class, "using");

    public CreateAction(CrudRepository<TEntity, ?> repository, DtoMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }

    public <TDto> CreateAction<TEntity> with(TDto requestDto) {
        this.dtoSupplier = () -> requestDto;
        return this;
    }

    public CreateAction<TEntity> using(TEntity initialEntity) {
        this.entitySupplier = () -> initialEntity;
        return this;
    }

    public <TResponseDto> ResponseEntity<TResponseDto> execute(Class<TResponseDto> responseDtoClass) {
        TEntity entity = this.entitySupplier.get();
        this.mapper.map(this.dtoSupplier.get(), entity);
        Object persistedEntity = this.repository.save(entity);
        TResponseDto responseDto = this.mapper.map(persistedEntity, responseDtoClass);
        return new ResponseEntity(responseDto, HttpStatus.CREATED);
    }
}

