/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action;

import ch.puzzle.libpuzzle.springframework.boot.rest.IllegalActionParam;
import java.util.function.Supplier;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class DeleteAction<TEntityId> {
    private CrudRepository<?, TEntityId> repository;
    private Supplier<TEntityId> idSupplier = IllegalActionParam.missingParam(DeleteAction.class, "by");

    public DeleteAction(CrudRepository<?, TEntityId> repository) {
        this.repository = repository;
    }

    public DeleteAction<TEntityId> by(TEntityId id) {
        this.idSupplier = () -> id;
        return this;
    }

    public ResponseEntity<Void> execute() {
        TEntityId id = this.idSupplier.get();
        if (!this.repository.existsById(id)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.repository.deleteById(id);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

