/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action;

import ch.puzzle.libpuzzle.springframework.boot.rest.CrudActions;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.CreateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.CrudActionsConfiguration;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.DeleteAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.FindAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.ListAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.UpdateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.mapper.DtoMapper;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Service;

@Service
public class RepositoryActions {
    private final DtoMapper dtoMapper;

    public RepositoryActions(DtoMapper dtoMapper) {
        this.dtoMapper = dtoMapper;
    }

    public <TEntity, TEntityId> Configurer<TEntity, TEntityId> forRepository(CrudRepository<TEntity, TEntityId> repository) {
        return new Configurer<TEntity, TEntityId>(repository, this.dtoMapper);
    }

    private static class Configurer<TEntity, TEntityId>
    implements CrudActionsConfiguration<ListAction<TEntity>, FindAction<TEntity, TEntityId>, CreateAction<TEntity>, UpdateAction<TEntity, TEntityId>, DeleteAction<TEntityId>> {
        private CrudRepository<TEntity, TEntityId> repository;
        private DtoMapper dtoMapper;

        private Configurer(CrudRepository<TEntity, TEntityId> repository, DtoMapper dtoMapper) {
            this.repository = repository;
            this.dtoMapper = dtoMapper;
        }

        @Override
        public void apply(CrudActions.Config config) {
            config.useListAction(() -> new ListAction<TEntity>(this.repository, this.dtoMapper)).useFindAction(() -> new FindAction<TEntity, TEntityId>(this.repository, this.dtoMapper)).useCreateAction(() -> new CreateAction<TEntity>(this.repository, this.dtoMapper)).useUpdateAction(() -> new UpdateAction<TEntity, TEntityId>(this.repository, this.dtoMapper)).useDeleteAction(() -> new DeleteAction<TEntityId>(this.repository));
        }
    }
}

