/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action;

import ch.puzzle.libpuzzle.springframework.boot.rest.IllegalActionParam;
import ch.puzzle.libpuzzle.springframework.boot.rest.mapper.DtoMapper;
import java.util.function.Supplier;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class UpdateAction<TEntity, TEntityId> {
    private CrudRepository<TEntity, TEntityId> repository;
    private DtoMapper mapper;
    private Supplier<Object> dtoSupplier = IllegalActionParam.missingParam(UpdateAction.class, "with");
    private Supplier<TEntityId> idSupplier = IllegalActionParam.missingParam(UpdateAction.class, "by");

    public UpdateAction(CrudRepository<TEntity, TEntityId> repository, DtoMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }

    public UpdateAction<TEntity, TEntityId> by(TEntityId id) {
        this.idSupplier = () -> id;
        return this;
    }

    public <TDto> UpdateAction<TEntity, TEntityId> with(TDto requestDto) {
        this.dtoSupplier = () -> requestDto;
        return this;
    }

    public <TResponseDto> ResponseEntity<TResponseDto> execute(Class<TResponseDto> responseDtoClass) {
        return this.repository.findById(this.idSupplier.get()).map(entity -> this.mapAndSave(this.dtoSupplier.get(), entity)).map(entity -> this.mapper.map(entity, responseDtoClass)).map(responseDto -> new ResponseEntity(responseDto, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    private <TDto> TEntity mapAndSave(TDto dto, TEntity entity) {
        this.mapper.map(dto, entity);
        return (TEntity)this.repository.save(entity);
    }
}

