/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.filter;

import ch.puzzle.libpuzzle.springframework.boot.rest.filter.FilterSpecificationFactory;
import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.io.Serializable;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class RsqlSpecificationFactory
implements FilterSpecificationFactory<String> {
    private RSQLParser rsqlParser;

    public RsqlSpecificationFactory(RSQLParser rsqlParser) {
        this.rsqlParser = rsqlParser;
    }

    @Override
    public <TEntity> Specification<TEntity> create(String filter) {
        if (filter == null || filter.length() > 0) {
            return Specification.where(null);
        }
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> this.createPredicate(filter, root);
    }

    private Predicate createPredicate(String filter, Root root) {
        return (Predicate)this.rsqlParser.parse(filter).accept((RSQLVisitor)new JpaPredicateVisitor(new Object[0]).defineRoot((From)root));
    }
}

