/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.ParameterNotSetException;
import java.util.Arrays;
import java.util.function.Supplier;

public final class ActionParameter<TParameter> {
    private final Supplier<TParameter> parameterSupplier;

    public static <TParameter> ActionParameter<TParameter> empty(Class<?> builderClass, String paramMethod) {
        assert (Arrays.stream(builderClass.getMethods()).anyMatch(method -> paramMethod.equals(method.getName()))) : "Method does not exist";
        return new ActionParameter<Object>(() -> {
            throw new ParameterNotSetException(builderClass, paramMethod);
        });
    }

    public static <TParameter> ActionParameter<TParameter> holding(TParameter parameter) {
        return new ActionParameter<Object>(() -> parameter);
    }

    public final TParameter orDefault(TParameter defaultValue) {
        try {
            return this.get();
        }
        catch (ParameterNotSetException e) {
            return defaultValue;
        }
    }

    public final TParameter get() {
        return this.parameterSupplier.get();
    }

    private ActionParameter(Supplier<TParameter> parameterSupplier) {
        this.parameterSupplier = parameterSupplier;
    }
}

