/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.CrudActions;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.create.CreateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.delete.DeleteAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.find.FindAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.list.ListAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.update.UpdateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.actionfactory.CrudActionsPresetConfigurer;

public final class CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>> {
    final CreateAction<TEntity> createAction;
    final FindAction<TIdentifier> findAction;
    final ListAction<TFilter> listAction;
    final UpdateAction<TIdentifier> updateAction;
    final DeleteAction<TIdentifier> deleteAction;
    private final TCrudActions crudActions;

    CrudActionsPreset(TCrudActions crudActions) {
        this(CreateAction.unsupported(), FindAction.unsupported(), ListAction.unsupported(), UpdateAction.unsupported(), DeleteAction.unsupported(), crudActions);
    }

    public TCrudActions apply() {
        ((CrudActions)this.crudActions).apply(this);
        return this.crudActions;
    }

    public final CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> with(CreateAction<TEntity> action) {
        return this.withCreateAction(action);
    }

    public final CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> with(FindAction<TIdentifier> action) {
        return this.withFindAction(action);
    }

    public final CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> with(ListAction<TFilter> action) {
        return this.withListAction(action);
    }

    public final CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> with(UpdateAction<TIdentifier> action) {
        return this.withUpdateAction(action);
    }

    public final CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> with(DeleteAction<TIdentifier> action) {
        return this.withDeleteAction(action);
    }

    public final CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> with(CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> configurer) {
        return configurer.configure(this);
    }

    public CrudActionsPreset(CreateAction<TEntity> createAction, FindAction<TIdentifier> findAction, ListAction<TFilter> listAction, UpdateAction<TIdentifier> updateAction, DeleteAction<TIdentifier> deleteAction, TCrudActions crudActions) {
        this.createAction = createAction;
        this.findAction = findAction;
        this.listAction = listAction;
        this.updateAction = updateAction;
        this.deleteAction = deleteAction;
        this.crudActions = crudActions;
    }

    private CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> withCreateAction(CreateAction<TEntity> createAction) {
        return this.createAction == createAction ? this : new CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions>(createAction, this.findAction, this.listAction, this.updateAction, this.deleteAction, this.crudActions);
    }

    private CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> withFindAction(FindAction<TIdentifier> findAction) {
        return this.findAction == findAction ? this : new CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions>(this.createAction, findAction, this.listAction, this.updateAction, this.deleteAction, this.crudActions);
    }

    private CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> withListAction(ListAction<TFilter> listAction) {
        return this.listAction == listAction ? this : new CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions>(this.createAction, this.findAction, listAction, this.updateAction, this.deleteAction, this.crudActions);
    }

    private CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> withUpdateAction(UpdateAction<TIdentifier> updateAction) {
        return this.updateAction == updateAction ? this : new CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions>(this.createAction, this.findAction, this.listAction, updateAction, this.deleteAction, this.crudActions);
    }

    private CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> withDeleteAction(DeleteAction<TIdentifier> deleteAction) {
        return this.deleteAction == deleteAction ? this : new CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions>(this.createAction, this.findAction, this.listAction, this.updateAction, deleteAction, this.crudActions);
    }
}

