/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action.create;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.ActionParameter;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.create.CreateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.create.CreateActionBuilder;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.create.CreateActionParameters;
import org.springframework.http.ResponseEntity;

public final class CreateActionExecution<TEntity, TDto, TResponseDto>
implements CreateActionBuilder<TEntity, TDto, TResponseDto>,
CreateActionParameters<TEntity, TDto, TResponseDto> {
    private final ActionParameter<TEntity> entity;
    private final ActionParameter<TDto> requestDto;
    private final ActionParameter<Class<TResponseDto>> responseDtoClass;
    private final CreateAction<TEntity> action;

    public CreateActionExecution(CreateAction<TEntity> action) {
        this(ActionParameter.empty(CreateActionBuilder.class, "using"), ActionParameter.empty(CreateActionBuilder.class, "with"), ActionParameter.empty(CreateActionBuilder.class, "execute"), action);
    }

    @Override
    public ActionParameter<TDto> requestDto() {
        return this.requestDto;
    }

    @Override
    public ActionParameter<TEntity> entity() {
        return this.entity;
    }

    @Override
    public ActionParameter<Class<TResponseDto>> responseDtoClass() {
        return this.responseDtoClass;
    }

    @Override
    public CreateActionBuilder<TEntity, TDto, TResponseDto> using(TEntity initialEntity) {
        return this.withEntity(ActionParameter.holding(initialEntity));
    }

    @Override
    public <TNewRequestDto> CreateActionBuilder<TEntity, TNewRequestDto, TResponseDto> with(TNewRequestDto requestDto) {
        return new CreateActionExecution<TEntity, TNewRequestDto, TResponseDto>(this.entity, ActionParameter.holding(requestDto), this.responseDtoClass, this.action);
    }

    @Override
    public <TNewResponseDto> ResponseEntity<TNewResponseDto> execute(Class<TNewResponseDto> responseDtoClass) {
        return this.action.execute(new CreateActionExecution<TEntity, TDto, TResponseDto>(this.entity, this.requestDto, ActionParameter.holding(responseDtoClass), this.action));
    }

    public CreateActionExecution(ActionParameter<TEntity> entity, ActionParameter<TDto> requestDto, ActionParameter<Class<TResponseDto>> responseDtoClass, CreateAction<TEntity> action) {
        this.entity = entity;
        this.requestDto = requestDto;
        this.responseDtoClass = responseDtoClass;
        this.action = action;
    }

    private CreateActionExecution<TEntity, TDto, TResponseDto> withEntity(ActionParameter<TEntity> entity) {
        return this.entity == entity ? this : new CreateActionExecution<TEntity, TDto, TResponseDto>(entity, this.requestDto, this.responseDtoClass, this.action);
    }
}

