/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action.find;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.ActionParameter;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.find.FindAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.find.FindActionBuilder;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.find.FindActionParameters;
import org.springframework.http.ResponseEntity;

public final class FindActionExecution<TIdentifier, TResponseDto>
implements FindActionBuilder<TIdentifier, TResponseDto>,
FindActionParameters<TIdentifier, TResponseDto> {
    private final ActionParameter<TIdentifier> identifier;
    private final ActionParameter<Class<TResponseDto>> responseDtoClass;
    private final FindAction<TIdentifier> action;

    public FindActionExecution(FindAction<TIdentifier> action) {
        this(ActionParameter.empty(FindActionBuilder.class, "by"), ActionParameter.empty(FindActionBuilder.class, "execute"), action);
    }

    @Override
    public ActionParameter<TIdentifier> identifier() {
        return this.identifier;
    }

    @Override
    public ActionParameter<Class<TResponseDto>> responseDtoClass() {
        return this.responseDtoClass;
    }

    @Override
    public FindActionBuilder<TIdentifier, TResponseDto> by(TIdentifier identifier) {
        return this.withIdentifier(ActionParameter.holding(identifier));
    }

    @Override
    public <TNewResponseDto> ResponseEntity<TNewResponseDto> execute(Class<TNewResponseDto> responseDtoClass) {
        return this.action.execute(new FindActionExecution<TIdentifier, TResponseDto>(this.identifier, ActionParameter.holding(responseDtoClass), this.action));
    }

    public FindActionExecution(ActionParameter<TIdentifier> identifier, ActionParameter<Class<TResponseDto>> responseDtoClass, FindAction<TIdentifier> action) {
        this.identifier = identifier;
        this.responseDtoClass = responseDtoClass;
        this.action = action;
    }

    private FindActionExecution<TIdentifier, TResponseDto> withIdentifier(ActionParameter<TIdentifier> identifier) {
        return this.identifier == identifier ? this : new FindActionExecution<TIdentifier, TResponseDto>(identifier, this.responseDtoClass, this.action);
    }
}

