/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action.list;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.ActionParameter;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.list.ListAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.list.ListActionBuilder;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.list.ListActionParameters;
import org.springframework.http.ResponseEntity;

public final class ListActionExecution<TFilter, TResponseDto>
implements ListActionBuilder<TFilter, TResponseDto>,
ListActionParameters<TFilter, TResponseDto> {
    private final ActionParameter<Integer> offset;
    private final ActionParameter<Integer> limit;
    private final ActionParameter<TFilter> filter;
    private final ActionParameter<Class<TResponseDto>> responseDtoClass;
    private final ListAction<TFilter> action;

    public ListActionExecution(ListAction<TFilter> action, int defaultOffset, int defaultLimit) {
        this(ActionParameter.holding(defaultOffset), ActionParameter.holding(defaultLimit), ActionParameter.empty(ListActionBuilder.class, "matching"), ActionParameter.empty(ListActionBuilder.class, "execute"), action);
    }

    @Override
    public ActionParameter<TFilter> filter() {
        return this.filter;
    }

    @Override
    public ActionParameter<Integer> offset() {
        return this.offset;
    }

    @Override
    public ActionParameter<Integer> limit() {
        return this.limit;
    }

    @Override
    public ActionParameter<Class<TResponseDto>> responseDtoClass() {
        return this.responseDtoClass;
    }

    @Override
    public ListActionBuilder<TFilter, TResponseDto> skip(int offset) {
        return this.withOffset(ActionParameter.holding(offset));
    }

    @Override
    public ListActionBuilder<TFilter, TResponseDto> limit(int limit) {
        return this.withLimit(ActionParameter.holding(limit));
    }

    @Override
    public ListActionBuilder<TFilter, TResponseDto> matching(TFilter filter) {
        return this.withFilter(ActionParameter.holding(filter));
    }

    @Override
    public <TNewResponseDto> ResponseEntity<Iterable<TNewResponseDto>> execute(Class<TNewResponseDto> responseDtoClass) {
        return this.action.execute(new ListActionExecution<TFilter, TResponseDto>(this.offset, this.limit, this.filter, ActionParameter.holding(responseDtoClass), this.action));
    }

    public ListActionExecution(ActionParameter<Integer> offset, ActionParameter<Integer> limit, ActionParameter<TFilter> filter, ActionParameter<Class<TResponseDto>> responseDtoClass, ListAction<TFilter> action) {
        this.offset = offset;
        this.limit = limit;
        this.filter = filter;
        this.responseDtoClass = responseDtoClass;
        this.action = action;
    }

    private ListActionExecution<TFilter, TResponseDto> withOffset(ActionParameter<Integer> offset) {
        return this.offset == offset ? this : new ListActionExecution<TFilter, TResponseDto>(offset, this.limit, this.filter, this.responseDtoClass, this.action);
    }

    private ListActionExecution<TFilter, TResponseDto> withLimit(ActionParameter<Integer> limit) {
        return this.limit == limit ? this : new ListActionExecution<TFilter, TResponseDto>(this.offset, limit, this.filter, this.responseDtoClass, this.action);
    }

    private ListActionExecution<TFilter, TResponseDto> withFilter(ActionParameter<TFilter> filter) {
        return this.filter == filter ? this : new ListActionExecution<TFilter, TResponseDto>(this.offset, this.limit, filter, this.responseDtoClass, this.action);
    }

    private ListActionExecution<TFilter, TResponseDto> withResponseDtoClass(ActionParameter<Class<TResponseDto>> responseDtoClass) {
        return this.responseDtoClass == responseDtoClass ? this : new ListActionExecution<TFilter, TResponseDto>(this.offset, this.limit, this.filter, responseDtoClass, this.action);
    }
}

