/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.action.update;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.ActionParameter;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.update.UpdateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.update.UpdateActionBuilder;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.update.UpdateActionParameters;
import org.springframework.http.ResponseEntity;

public final class UpdateActionExecution<TEntity, TIdentifier, TRequestDto, TResponseDto>
implements UpdateActionBuilder<TEntity, TIdentifier, TRequestDto, TResponseDto>,
UpdateActionParameters<TIdentifier, TRequestDto, TResponseDto> {
    private final ActionParameter<TIdentifier> identifier;
    private final ActionParameter<TRequestDto> requestDto;
    private final ActionParameter<Class<TResponseDto>> responseDtoClass;
    private final UpdateAction<TIdentifier> action;

    public UpdateActionExecution(UpdateAction<TIdentifier> action) {
        this(ActionParameter.empty(UpdateActionBuilder.class, "by"), ActionParameter.empty(UpdateActionBuilder.class, "with"), ActionParameter.empty(UpdateActionBuilder.class, "execute"), action);
    }

    @Override
    public ActionParameter<TRequestDto> requestDto() {
        return this.requestDto;
    }

    @Override
    public ActionParameter<TIdentifier> identifier() {
        return this.identifier;
    }

    @Override
    public ActionParameter<Class<TResponseDto>> responseDtoClass() {
        return this.responseDtoClass;
    }

    @Override
    public UpdateActionBuilder<TEntity, TIdentifier, TRequestDto, TResponseDto> by(TIdentifier identifier) {
        return this.withIdentifier(ActionParameter.holding(identifier));
    }

    @Override
    public <TNewRequestDto> UpdateActionBuilder<TEntity, TIdentifier, TNewRequestDto, TResponseDto> with(TNewRequestDto requestDto) {
        return new UpdateActionExecution<TEntity, TIdentifier, TNewRequestDto, TResponseDto>(this.identifier, ActionParameter.holding(requestDto), this.responseDtoClass, this.action);
    }

    @Override
    public <TNewResponseDto> ResponseEntity<TNewResponseDto> execute(Class<TNewResponseDto> responseDtoClass) {
        return this.action.execute(new UpdateActionExecution<TEntity, TIdentifier, TRequestDto, TResponseDto>(this.identifier, this.requestDto, ActionParameter.holding(responseDtoClass), this.action));
    }

    public UpdateActionExecution(ActionParameter<TIdentifier> identifier, ActionParameter<TRequestDto> requestDto, ActionParameter<Class<TResponseDto>> responseDtoClass, UpdateAction<TIdentifier> action) {
        this.identifier = identifier;
        this.requestDto = requestDto;
        this.responseDtoClass = responseDtoClass;
        this.action = action;
    }

    private UpdateActionExecution<TEntity, TIdentifier, TRequestDto, TResponseDto> withIdentifier(ActionParameter<TIdentifier> identifier) {
        return this.identifier == identifier ? this : new UpdateActionExecution<TEntity, TIdentifier, TRequestDto, TResponseDto>(identifier, this.requestDto, this.responseDtoClass, this.action);
    }
}

