/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.actionfactory;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.CrudActions;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.CrudActionsPreset;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.create.CreateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.delete.DeleteAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.find.FindAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.list.ListAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.update.UpdateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.actionfactory.CrudActionsPresetConfigurer;

public abstract class CrudActionFactory<TEntity, TIdentifier, TFilter> {
    public abstract CreateAction<TEntity> create();

    public abstract FindAction<TIdentifier> find();

    public abstract ListAction<TFilter> list();

    public abstract UpdateAction<TIdentifier> update();

    public abstract DeleteAction<TIdentifier> delete();

    public <TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>> CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> readOnly() {
        return new ReadActionsPresetConfigurer(this);
    }

    public <TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>> CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> writeOnly() {
        return new WriteActionsPresetConfigurer(this);
    }

    public <TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>> CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> resourceOnly() {
        return new ResourceActionsPresetConfigurer(this);
    }

    public <TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>> CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> all() {
        return new AllActionsPresetConfigurer(this);
    }

    private static final class AllActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>>
    implements CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> {
        private final CrudActionFactory<TEntity, TIdentifier, TFilter> repositoryActions;

        @Override
        public CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> configure(CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> preset) {
            return preset.with(this.repositoryActions.create()).with(this.repositoryActions.find()).with(this.repositoryActions.list()).with(this.repositoryActions.update()).with(this.repositoryActions.delete());
        }

        public AllActionsPresetConfigurer(CrudActionFactory<TEntity, TIdentifier, TFilter> repositoryActions) {
            this.repositoryActions = repositoryActions;
        }
    }

    private static final class ResourceActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>>
    implements CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> {
        private final CrudActionFactory<TEntity, TIdentifier, TFilter> repositoryActions;

        @Override
        public CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> configure(CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> preset) {
            return preset.with(this.repositoryActions.create()).with(this.repositoryActions.find()).with(this.repositoryActions.update()).with(this.repositoryActions.delete());
        }

        public ResourceActionsPresetConfigurer(CrudActionFactory<TEntity, TIdentifier, TFilter> repositoryActions) {
            this.repositoryActions = repositoryActions;
        }
    }

    private static final class WriteActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>>
    implements CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> {
        private final CrudActionFactory<TEntity, TIdentifier, TFilter> crudActionFactory;

        @Override
        public CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> configure(CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> preset) {
            return preset.with(this.crudActionFactory.create()).with(this.crudActionFactory.update()).with(this.crudActionFactory.delete());
        }

        public WriteActionsPresetConfigurer(CrudActionFactory<TEntity, TIdentifier, TFilter> crudActionFactory) {
            this.crudActionFactory = crudActionFactory;
        }
    }

    private static final class ReadActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions extends CrudActions<TEntity, TIdentifier, TFilter, TCrudActions>>
    implements CrudActionsPresetConfigurer<TEntity, TIdentifier, TFilter, TCrudActions> {
        private final CrudActionFactory<TEntity, TIdentifier, TFilter> crudActionFactory;

        @Override
        public CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> configure(CrudActionsPreset<TEntity, TIdentifier, TFilter, TCrudActions> preset) {
            return preset.with(this.crudActionFactory.find()).with(this.crudActionFactory.list());
        }

        public ReadActionsPresetConfigurer(CrudActionFactory<TEntity, TIdentifier, TFilter> crudActionFactory) {
            this.crudActionFactory = crudActionFactory;
        }
    }
}

