/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.repository.actionfactory;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.create.CreateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.delete.DeleteAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.find.FindAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.list.ListAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.update.UpdateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.actionfactory.CrudActionFactory;
import ch.puzzle.libpuzzle.springframework.boot.rest.mapper.DtoMapper;
import ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions.RepositoryCreateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions.RepositoryDeleteAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions.RepositoryFindAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions.RepositoryListAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions.RepositoryUpdateAction;
import java.util.function.Predicate;
import org.springframework.data.repository.CrudRepository;

public class RepositoryActions<TEntity, TIdentifier>
extends CrudActionFactory<TEntity, TIdentifier, Predicate<TEntity>> {
    private final CrudRepository<TEntity, TIdentifier> repository;
    private final DtoMapper dtoMapper;

    @Override
    public CreateAction<TEntity> create() {
        return new RepositoryCreateAction<TEntity>(this.repository, this.dtoMapper);
    }

    @Override
    public FindAction<TIdentifier> find() {
        return new RepositoryFindAction<TEntity, TIdentifier>(this.repository, this.dtoMapper);
    }

    @Override
    public ListAction<Predicate<TEntity>> list() {
        return new RepositoryListAction<TEntity>(this.repository, this.dtoMapper);
    }

    @Override
    public UpdateAction<TIdentifier> update() {
        return new RepositoryUpdateAction<TEntity, TIdentifier>(this.repository, this.dtoMapper);
    }

    @Override
    public DeleteAction<TIdentifier> delete() {
        return new RepositoryDeleteAction<TIdentifier>(this.repository);
    }

    public RepositoryActions(CrudRepository<TEntity, TIdentifier> repository, DtoMapper dtoMapper) {
        this.repository = repository;
        this.dtoMapper = dtoMapper;
    }
}

