/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.create.CreateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.create.CreateActionParameters;
import ch.puzzle.libpuzzle.springframework.boot.rest.mapper.DtoMapper;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class RepositoryCreateAction<TEntity>
implements CreateAction<TEntity> {
    private CrudRepository<TEntity, ?> repository;
    private DtoMapper mapper;

    public RepositoryCreateAction(CrudRepository<TEntity, ?> repository, DtoMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }

    @Override
    public <TResponseDto> ResponseEntity<TResponseDto> execute(CreateActionParameters<TEntity, ?, TResponseDto> params) {
        TEntity entity = params.entity().get();
        this.mapper.map(params.requestDto().get(), entity);
        Object persistedEntity = this.repository.save(entity);
        TResponseDto responseDto = this.mapper.map(persistedEntity, params.responseDtoClass().get());
        return new ResponseEntity(responseDto, HttpStatus.CREATED);
    }
}

