/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.ActionParameter;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.delete.DeleteAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.delete.DeleteActionParameters;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class RepositoryDeleteAction<TIdentifier>
implements DeleteAction<TIdentifier> {
    private final CrudRepository<?, TIdentifier> repository;

    @Override
    public ResponseEntity<Void> execute(DeleteActionParameters<TIdentifier> params) {
        ActionParameter<TIdentifier> identifier = params.identifier();
        if (!this.repository.existsById(identifier.get())) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.repository.deleteById(identifier.get());
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    public RepositoryDeleteAction(CrudRepository<?, TIdentifier> repository) {
        this.repository = repository;
    }
}

