/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.find.FindAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.find.FindActionParameters;
import ch.puzzle.libpuzzle.springframework.boot.rest.mapper.DtoMapper;
import java.util.Optional;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class RepositoryFindAction<TEntity, TIdentifier>
implements FindAction<TIdentifier> {
    private final CrudRepository<TEntity, TIdentifier> repository;
    private final DtoMapper mapper;

    @Override
    public <TResponseDto> ResponseEntity<TResponseDto> execute(FindActionParameters<TIdentifier, TResponseDto> params) {
        Optional entity = this.repository.findById(params.identifier().get());
        if (entity.isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        TResponseDto dto = this.mapper.map(entity.get(), params.responseDtoClass().get());
        return new ResponseEntity(dto, HttpStatus.OK);
    }

    public RepositoryFindAction(CrudRepository<TEntity, TIdentifier> repository, DtoMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }
}

