/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.list.ListAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.list.ListActionParameters;
import ch.puzzle.libpuzzle.springframework.boot.rest.mapper.DtoMapper;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class RepositoryListAction<TEntity>
implements ListAction<Predicate<TEntity>> {
    private final Predicate<TEntity> DEFAULT_FILTER = entity -> true;
    private final CrudRepository<TEntity, ?> repository;
    private final DtoMapper mapper;

    public static <TEntity> Predicate<TEntity> allFilter() {
        return entity -> true;
    }

    @Override
    public <TResponseDto> ResponseEntity<Iterable<TResponseDto>> execute(ListActionParameters<Predicate<TEntity>, TResponseDto> params) {
        List list = StreamSupport.stream(this.repository.findAll().spliterator(), true).filter(params.filter().orDefault(this.DEFAULT_FILTER)).skip(params.offset().get().intValue()).limit(params.limit().get().intValue()).map(entity -> this.mapper.map(entity, params.responseDtoClass().get())).collect(Collectors.toList());
        return new ResponseEntity(list, HttpStatus.OK);
    }

    public RepositoryListAction(CrudRepository<TEntity, ?> repository, DtoMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }
}

