/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.repository.actions;

import ch.puzzle.libpuzzle.springframework.boot.rest.action.update.UpdateAction;
import ch.puzzle.libpuzzle.springframework.boot.rest.action.update.UpdateActionParameters;
import ch.puzzle.libpuzzle.springframework.boot.rest.mapper.DtoMapper;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class RepositoryUpdateAction<TEntity, TIdentifier>
implements UpdateAction<TIdentifier> {
    private final CrudRepository<TEntity, TIdentifier> repository;
    private final DtoMapper mapper;

    @Override
    public <TResponseDto> ResponseEntity<TResponseDto> execute(UpdateActionParameters<TIdentifier, ?, TResponseDto> params) {
        return this.repository.findById(params.identifier().get()).map(entity -> this.mapAndSave(params.requestDto().get(), entity)).map(entity -> this.mapper.map(entity, params.responseDtoClass().get())).map(responseDto -> new ResponseEntity(responseDto, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    private <TDto> TEntity mapAndSave(TDto dto, TEntity entity) {
        this.mapper.map(dto, entity);
        return (TEntity)this.repository.save(entity);
    }

    public RepositoryUpdateAction(CrudRepository<TEntity, TIdentifier> repository, DtoMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }
}

