/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.common.pattern;

import ch.qos.logback.access.common.pattern.AccessConverter;
import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.time.ZoneId;
import java.util.List;

public class DateConverter
extends AccessConverter {
    CachingDateFormatter cachingDateFormatter = null;

    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "dd/MMM/yyyy:HH:mm:ss Z";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        ZoneId zoneId = null;
        List optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            String zoneIdString = (String)optionList.get(1);
            zoneId = ZoneId.of(zoneIdString);
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(datePattern, zoneId);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e);
            this.addWarn("Defaulting to  dd/MMM/yyyy:HH:mm:ss Z");
            this.cachingDateFormatter = new CachingDateFormatter("dd/MMM/yyyy:HH:mm:ss Z", zoneId);
        }
    }

    public String convert(IAccessEvent accessEvent) {
        long timestamp = accessEvent.getTimeStamp();
        return this.cachingDateFormatter.format(timestamp);
    }

    public CachingDateFormatter internalCachingDateFormatter() {
        return this.cachingDateFormatter;
    }
}

