/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.common.testUtil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetUtil {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    URL url;
    HttpURLConnection conn;
    String requestMethod = "GET";

    public HttpGetUtil(String urlStr) throws MalformedURLException {
        this.url = new URL(urlStr);
    }

    public HttpGetUtil init() {
        if (this.conn != null) {
            throw new IllegalStateException("Already initialized");
        }
        try {
            this.conn = (HttpURLConnection)this.url.openConnection();
            this.conn.setRequestMethod(this.requestMethod);
            return this;
        }
        catch (IOException e) {
            this.logger.atError().addKeyValue("url", (Object)this.url.toString()).setCause((Throwable)e).log("Failed to connect");
            return this;
        }
    }

    public HttpGetUtil addRequestProperty(String key, String val) {
        this.conn.addRequestProperty(key, val);
        return this;
    }

    public HttpGetUtil addCookie(String val) {
        return this.addRequestProperty("Cookie", val);
    }

    public HttpURLConnection connect() {
        try {
            this.conn.connect();
            return this.conn;
        }
        catch (IOException e) {
            this.logger.atError().addKeyValue("url", (Object)this.url.toString()).setCause((Throwable)e).log("Failed to connect");
            return null;
        }
    }

    public String readResponse() {
        if (this.conn == null) {
            return null;
        }
        try {
            int responseCode = this.conn.getResponseCode();
            if (responseCode == 200) {
                return this.innerReadResponse();
            }
            this.logger.atError().addKeyValue("status", (Object)responseCode).log("Failed response");
            return null;
        }
        catch (IOException e) {
            this.logger.atError().addKeyValue("url", (Object)this.url.toString()).setCause((Throwable)e).log("failed to read status");
            return null;
        }
    }

    private String innerReadResponse() {
        String string;
        block9: {
            InputStream is = this.conn.getInputStream();
            try {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                StringBuffer buffer = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    buffer.append(inputLine);
                }
                string = buffer.toString();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.atError().addKeyValue("url", (Object)this.url.toString()).setCause((Throwable)e).log("failed");
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    public void disconnect() {
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }
}

