/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit;

import ch.qos.logback.audit.Application;
import ch.qos.logback.audit.Predicate;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditEvent
implements Serializable {
    private static final long serialVersionUID = 6641931592187864466L;
    Long id;
    private Timestamp timestamp;
    String subject;
    String verb;
    String object;
    Map<String, String> predicateMap = new HashMap<String, String>();
    Application originatingApplication;
    Application clientApplication;

    AuditEvent() {
        this.timestamp = new Timestamp(System.currentTimeMillis());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public Application getClientApplication() {
        return this.clientApplication;
    }

    public void setClientApplication(Application clientApplication) {
        this.clientApplication = clientApplication;
    }

    public Application getOriginatingApplication() {
        return this.originatingApplication;
    }

    public void setOriginatingApplication(Application originatingApplication) {
        this.originatingApplication = originatingApplication;
    }

    public void addPredicate(Predicate predicate) {
        this.predicateMap.put(predicate.getName(), predicate.getValue());
    }

    public void setPredicateMap(Map<String, String> predicateMap) {
        this.predicateMap = predicateMap;
    }

    public Map<String, String> getPredicateMap() {
        return this.predicateMap;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditEvent other = (AuditEvent)obj;
        if (!this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        if (this.verb == null ? other.verb != null : !this.verb.equals(other.verb)) {
            return false;
        }
        if (this.object == null ? other.object != null : !this.object.equals(other.object)) {
            return false;
        }
        if (this.clientApplication == null ? other.clientApplication != null : !this.clientApplication.equals(other.clientApplication)) {
            return false;
        }
        if (this.originatingApplication == null ? other.originatingApplication != null : !this.originatingApplication.equals(other.originatingApplication)) {
            return false;
        }
        return !(this.predicateMap == null ? other.predicateMap != null : !((Object)this.predicateMap).equals(other.predicateMap));
    }

    public String toString() {
        String retValue = "";
        retValue = "AuditEvent(id=" + this.id + ", timestamp=" + this.timestamp + ", subject=" + this.subject + ", verb=" + this.verb + ", object=" + this.object + ", predicateMap = " + this.predicateMap + ", originatingApplication=" + this.originatingApplication + ", clientApplication=" + this.clientApplication + ")";
        return retValue;
    }
}

