/*
 * Decompiled with CFR 0.152.
 */
package examples.access;

import ch.qos.logback.audit.AuditException;
import ch.qos.logback.audit.client.AuditorFacade;
import ch.qos.logback.audit.client.AuditorFactory;
import examples.access.AccessException;
import examples.access.AuditHelper;
import examples.access.Permission;
import examples.access.PermissionMap;
import examples.access.User;

public class AccessRightsChecker {
    static String ACCESS_RIGHTS_CHECKER_APPLICATION_NAME = "AccessRightsChecker";
    final PermissionMap permissionMap;

    public AccessRightsChecker(PermissionMap permissionMap) {
        this.permissionMap = permissionMap;
    }

    public boolean hasPermission(User user, Permission permission) throws AccessException {
        boolean allowed = this.permissionMap.hasPermission(user, permission);
        if (!allowed) {
            AuditorFacade auditorFacade = new AuditorFacade(user.getName(), "ACCESS_DENIED", permission.getName());
            AuditHelper.audit(auditorFacade);
        }
        return allowed;
    }

    public static void main(String[] args) throws AuditException, AccessException {
        AuditorFactory.setApplicationName((String)ACCESS_RIGHTS_CHECKER_APPLICATION_NAME);
        PermissionMap pm = new PermissionMap();
        User bob = new User("Bob");
        User carol = new User("Carol");
        User dave = new User("Dave");
        Permission browsePerm = new Permission("browse");
        pm.addPermission(dave, browsePerm);
        AccessRightsChecker arc = new AccessRightsChecker(pm);
        arc.hasPermission(bob, browsePerm);
        arc.hasPermission(carol, browsePerm);
        arc.hasPermission(dave, browsePerm);
    }
}

