/*
 * Decompiled with CFR 0.152.
 */
package examples.access;

import ch.qos.logback.audit.AuditException;
import ch.qos.logback.audit.client.AuditorFacade;
import ch.qos.logback.audit.client.AuditorFactory;
import examples.access.AccessException;
import examples.access.AuditHelper;
import examples.access.Permission;
import examples.access.PermissionMap;
import examples.access.User;

public class AccessRightsAdministrator {
    static String ACCESS_RIGHTS_ADMIN_APPLICATION_NAME = "AccessRightsAdmin";
    static String ADD_PERMISSION_VERB = "ADD_PERMISSION";
    static String REMOVE_PERMISSION_VERB = "REMOVE_PERMISSION";
    final PermissionMap permissionMap = new PermissionMap();

    public void addPermission(User user, Permission permission) throws AccessException {
        this.permissionMap.addPermission(user, permission);
        AuditorFacade auditorFacade = new AuditorFacade(user.getName(), ADD_PERMISSION_VERB, permission.getName());
        try {
            auditorFacade.audit();
        }
        catch (AuditException e) {
            throw new AccessException("Audit failure", e);
        }
    }

    public void removePermission(User user, Permission permission) throws AccessException {
        this.permissionMap.removePermission(user, permission);
        AuditorFacade auditorFacade = new AuditorFacade(user.getName(), REMOVE_PERMISSION_VERB, permission.getName());
        AuditHelper.audit(auditorFacade);
    }

    public static void main(String[] args) throws AuditException, AccessException {
        AuditorFactory.setApplicationName((String)ACCESS_RIGHTS_ADMIN_APPLICATION_NAME);
        AccessRightsAdministrator ara = new AccessRightsAdministrator();
        User alice = new User("alice");
        User bob = new User("bob");
        User carol = new User("carol");
        User dave = new User("dave");
        Permission adminPerm = new Permission("administrator");
        Permission createPerm = new Permission("create");
        Permission commentPerm = new Permission("comment");
        Permission votePerm = new Permission("vote");
        Permission browsePerm = new Permission("browse");
        ara.addPermission(alice, adminPerm);
        ara.addPermission(bob, createPerm);
        ara.addPermission(bob, commentPerm);
        ara.addPermission(bob, votePerm);
        ara.addPermission(carol, browsePerm);
        ara.addPermission(dave, browsePerm);
        ara.removePermission(bob, createPerm);
        ara.removePermission(bob, commentPerm);
        ara.removePermission(bob, votePerm);
    }
}

