/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.server;

import ch.qos.logback.audit.server.AuditEventHandler;
import ch.qos.logback.audit.server.SocketNode;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditServer
extends Thread {
    static Logger logger = LoggerFactory.getLogger(AuditServer.class);
    final int port;
    final AuditEventHandler auditEventHandler;
    boolean closed = false;
    boolean serverSocketSucessfullyOpened = false;
    ServerSocket serverSocket;
    List<SocketNode> socketNodeList = new ArrayList<SocketNode>();

    public AuditServer(int port, AuditEventHandler auditEventHandler) {
        this.port = port;
        this.auditEventHandler = auditEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            logger.info("Listening on port " + this.port);
            this.serverSocket = new ServerSocket(this.port);
            this.serverSocketSucessfullyOpened = true;
            while (!this.closed) {
                logger.info("Waiting to accept a new client.");
                Socket socket = this.serverSocket.accept();
                InetAddress inetAddress = socket.getInetAddress();
                logger.info("Connected to client at " + inetAddress);
                logger.info("Starting new socket node.");
                SocketNode newSocketNode = new SocketNode(this, socket, this.auditEventHandler);
                List<SocketNode> list = this.socketNodeList;
                synchronized (list) {
                    this.socketNodeList.add(newSocketNode);
                }
                new Thread(newSocketNode).start();
            }
        }
        catch (SocketException e) {
            if ("socket closed".equals(e.getMessage())) {
                logger.info("Audit server has been closed");
            } else {
                logger.info("Caught an SocketException", (Throwable)e);
            }
        }
        catch (IOException e) {
            logger.info("Caught an IOException", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Caught an unexpectged exception.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void socketNodeClosing(SocketNode sn) {
        logger.debug("Removing {}", (Object)sn);
        List<SocketNode> list = this.socketNodeList;
        synchronized (list) {
            this.socketNodeList.remove(sn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                logger.error("Failed to close serverSocket", (Throwable)e);
            }
        }
        List<SocketNode> list = this.socketNodeList;
        synchronized (list) {
            for (SocketNode sn : this.socketNodeList) {
                sn.close();
            }
        }
    }

    public boolean isServerSocketSucessfullyOpened() {
        return this.serverSocketSucessfullyOpened;
    }
}

