/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.server;

import ch.qos.logback.audit.persistent.AuditEventShaper;
import ch.qos.logback.audit.persistent.NullAEShaper;
import ch.qos.logback.audit.persistent.Persistor;
import ch.qos.logback.audit.persistent.SQLServerAEShaper;
import ch.qos.logback.audit.server.AuditEventPersistor;
import ch.qos.logback.audit.server.AuditServer;
import ch.qos.logback.audit.server.helper.ResourceUtil;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextListener
implements javax.servlet.ServletContextListener {
    Logger logger = LoggerFactory.getLogger(ServletContextListener.class);
    String applicationName;
    Object lock = new Object();
    AuditServer auditServer;

    public void contextDestroyed(ServletContextEvent sce) {
        this.logger.info("Resetting configuration");
        Persistor.resetConfiguration(this.lock);
        this.auditServer.close();
    }

    public void contextInitialized(ServletContextEvent sce) {
        AuditEventShaper auditEventShaper;
        this.logger.debug("ContextListener.contextInitialized called");
        ServletContext servletContext = sce.getServletContext();
        String portStr = servletContext.getInitParameter("PORT");
        if (portStr == null || "".equals(portStr)) {
            this.logger.error("The PORT argument was not set in web.xml. Aborting");
            return;
        }
        int port = Integer.parseInt(portStr);
        String rdbmsDialect = servletContext.getInitParameter("RDBMS_DIALECT");
        if ("SQLSERVER_2005".equalsIgnoreCase(rdbmsDialect)) {
            this.logger.info("Will shape events accord to SQL Server 2005 requirements");
            auditEventShaper = new SQLServerAEShaper();
        } else {
            auditEventShaper = new NullAEShaper();
        }
        this.applicationName = servletContext.getServletContextName();
        this.logger.debug("applicationName={}", (Object)this.applicationName);
        Configuration cfg = Persistor.createConfiguration();
        ResourceUtil.setApplicationName(this.applicationName);
        Properties props = ResourceUtil.getProps(this.applicationName + "/hibernate.properties");
        cfg.setProperties(props);
        Persistor.setConfiguration(cfg, this.lock);
        this.auditServer = new AuditServer(port, new AuditEventPersistor(auditEventShaper));
        this.auditServer.start();
        servletContext.setAttribute("AUDIT_SERVER_REFERENCE", (Object)this.auditServer);
    }
}

