/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.eclipse;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.contrib.eclipse.IPlatform;
import ch.qos.logback.core.AppenderBase;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class EclipseLogAppender
extends AppenderBase<ILoggingEvent> {
    public static final String DEFAULT_BUNDLE_SYMBOLIC_NAME = "ch.qos.logback.contrib.eclipse";
    private static final IPlatform _platform = new IPlatform(){

        @Override
        public ILog getLog(Bundle bundle) {
            return Platform.getLog((Bundle)bundle);
        }

        @Override
        public Bundle getBundle(String string) {
            return Platform.getBundle((String)string);
        }
    };
    private PatternLayoutEncoder _encoder = null;
    private ILog _eclipseLog = null;
    private String _bundleName = null;

    public void start() {
        Bundle bundle;
        if (this._encoder == null || this._encoder.getLayout() == null) {
            this.addError("No layout set for the appender named [" + this.name + "].");
            return;
        }
        if (this._bundleName == null) {
            this.addInfo("Assuming name of \"ch.qos.logback.contrib.eclipse\" for the appender named [" + this.name + "].");
            this._bundleName = DEFAULT_BUNDLE_SYMBOLIC_NAME;
        }
        if ((bundle = this.getPlatform().getBundle(this._bundleName)) == null) {
            this.addError("Invalid bundle name for the appender named [" + this.name + "].");
            return;
        }
        this._eclipseLog = this.getPlatform().getLog(bundle);
        super.start();
    }

    protected void append(ILoggingEvent iLoggingEvent) {
        int n;
        if (!this.isStarted()) {
            return;
        }
        int n2 = iLoggingEvent.getLevel().levelInt;
        switch (n2) {
            case 30000: {
                n = 2;
                break;
            }
            case 40000: {
                n = 4;
                break;
            }
            case 20000: {
                n = 1;
                break;
            }
            case 5000: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            String string = this._encoder.getLayout().doLayout((Object)iLoggingEvent);
            this._eclipseLog.log((IStatus)new Status(n, this._bundleName, n2, string, null));
        }
    }

    public PatternLayoutEncoder getEncoder() {
        return this._encoder;
    }

    public void setEncoder(PatternLayoutEncoder patternLayoutEncoder) {
        this._encoder = patternLayoutEncoder;
    }

    public String getBundleName() {
        return this._bundleName;
    }

    public void setBundleName(String string) {
        this._bundleName = string;
    }

    protected IPlatform getPlatform() {
        return _platform;
    }
}

