/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.json.access;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.contrib.json.JsonLayoutBase;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class JsonLayout
extends JsonLayoutBase<IAccessEvent> {
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String REMOTEADDR_ATTR_NAME = "remoteAddress";
    public static final String REMOTEUSER_ATTR_NAME = "remoteUser";
    public static final String REQUESTTIME_ATTR_NAME = "requestTime";
    public static final String REQUESTURI_ATTR_NAME = "uri";
    public static final String STATUSCODE_ATTR_NAME = "status";
    public static final String METHOD_ATTR_NAME = "method";
    public static final String PROTOCOL_ATTR_NAME = "protocol";
    public static final String CONTENTLENGTH_ATTR_NAME = "contentLength";
    public static final String REQUESTURL_ATTR_NAME = "url";
    public static final String REMOTEHOST_ATTR_NAME = "remoteHost";
    public static final String SERVERNAME_ATTR_NAME = "serverName";
    public static final String REQUESTHEADER_ATTR_NAME = "headers";
    public static final String REQUESTPARAMETER_ATTR_NAME = "params";
    public static final String LOCALPORT_ATTR_NAME = "port";
    public static final String REQUESTCONTENT_ATTR_NAME = "requestContent";
    public static final String RESPONSECONTENT_ATTR_NAME = "responseContent";
    protected boolean includeRemoteAddr = true;
    protected boolean includeRemoteUser = true;
    protected boolean includeRequestTime = true;
    protected boolean includeRequestURI = true;
    protected boolean includeStatusCode = true;
    protected boolean includeMethod = true;
    protected boolean includeProtocol = true;
    protected boolean includeContentLength = false;
    protected boolean includeRequestURL = false;
    protected boolean includeRemoteHost = true;
    protected boolean includeServerName = true;
    protected boolean includeRequestHeader = true;
    protected boolean includeRequestParameter = true;
    protected boolean includeLocalPort = false;
    protected boolean includeRequestContent = false;
    protected boolean includeResponseContent = false;

    protected Map toJsonMap(IAccessEvent iAccessEvent) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        this.addTimestamp(TIMESTAMP_ATTR_NAME, this.includeTimestamp, iAccessEvent.getTimeStamp(), linkedHashMap);
        this.add(REMOTEADDR_ATTR_NAME, this.includeRemoteAddr, iAccessEvent.getRemoteAddr(), linkedHashMap);
        this.add(REMOTEUSER_ATTR_NAME, this.includeRemoteUser, iAccessEvent.getRemoteUser(), linkedHashMap);
        this.addRequestTime(iAccessEvent.getElapsedTime(), linkedHashMap);
        this.addInt(STATUSCODE_ATTR_NAME, this.includeStatusCode, iAccessEvent.getStatusCode(), linkedHashMap);
        this.add(METHOD_ATTR_NAME, this.includeMethod, iAccessEvent.getMethod(), linkedHashMap);
        this.add(REQUESTURI_ATTR_NAME, this.includeRequestURI, iAccessEvent.getRequestURI(), linkedHashMap);
        this.add(PROTOCOL_ATTR_NAME, this.includeProtocol, iAccessEvent.getProtocol(), linkedHashMap);
        this.add(CONTENTLENGTH_ATTR_NAME, this.includeContentLength, Long.toString(iAccessEvent.getContentLength()), linkedHashMap);
        this.add(REQUESTURL_ATTR_NAME, this.includeRequestURL, iAccessEvent.getRequestURL(), linkedHashMap);
        this.add(REMOTEHOST_ATTR_NAME, this.includeRemoteHost, iAccessEvent.getRemoteHost(), linkedHashMap);
        this.add(SERVERNAME_ATTR_NAME, this.includeServerName, iAccessEvent.getServerName(), linkedHashMap);
        this.addMap(REQUESTHEADER_ATTR_NAME, this.includeRequestHeader, iAccessEvent.getRequestHeaderMap(), linkedHashMap);
        this.addMap(REQUESTPARAMETER_ATTR_NAME, this.includeRequestParameter, iAccessEvent.getRequestParameterMap(), linkedHashMap);
        this.addInt(LOCALPORT_ATTR_NAME, this.includeLocalPort, iAccessEvent.getLocalPort(), linkedHashMap);
        this.add(REQUESTCONTENT_ATTR_NAME, this.includeRequestContent, iAccessEvent.getRequestContent(), linkedHashMap);
        this.add(RESPONSECONTENT_ATTR_NAME, this.includeResponseContent, iAccessEvent.getResponseContent(), linkedHashMap);
        return linkedHashMap;
    }

    protected void addRequestTime(long l, Map<String, Object> map) {
        if (this.includeRequestTime && l > 0L) {
            long l2 = TimeUnit.MILLISECONDS.toSeconds(l);
            long l3 = TimeUnit.MILLISECONDS.toMillis(l - TimeUnit.SECONDS.toMillis(l2));
            String string = String.format("%01d.%03d", l2, l3);
            if (string != null) {
                map.put(REQUESTTIME_ATTR_NAME, string);
            }
        }
    }

    protected void addInt(String string, boolean bl, int n, Map<String, Object> map) {
        if (bl) {
            String string2 = String.valueOf(n);
            map.put(string, string2);
        }
    }

    public boolean isIncludeRemoteAddr() {
        return this.includeRemoteAddr;
    }

    public void setIncludeRemoteAddr(boolean bl) {
        this.includeRemoteAddr = bl;
    }

    public boolean isIncludeRemoteUser() {
        return this.includeRemoteUser;
    }

    public void setIncludeRemoteUser(boolean bl) {
        this.includeRemoteUser = bl;
    }

    public boolean isIncludeRequestTime() {
        return this.includeRequestTime;
    }

    public void setIncludeRequestTime(boolean bl) {
        this.includeRequestTime = bl;
    }

    public boolean isIncludeRequestURI() {
        return this.includeRequestURI;
    }

    public void setIncludeRequestURI(boolean bl) {
        this.includeRequestURI = bl;
    }

    public boolean isIncludeStatusCode() {
        return this.includeStatusCode;
    }

    public void setIncludeStatusCode(boolean bl) {
        this.includeStatusCode = bl;
    }

    public boolean isIncludeMethod() {
        return this.includeMethod;
    }

    public void setIncludeMethod(boolean bl) {
        this.includeMethod = bl;
    }

    public boolean isIncludeProtocol() {
        return this.includeProtocol;
    }

    public void setIncludeProtocol(boolean bl) {
        this.includeProtocol = bl;
    }

    public boolean isIncludeContentLength() {
        return this.includeContentLength;
    }

    public void setIncludeContentLength(boolean bl) {
        this.includeContentLength = bl;
    }

    public boolean isIncludeRequestURL() {
        return this.includeRequestURL;
    }

    public void setIncludeRequestURL(boolean bl) {
        this.includeRequestURL = bl;
    }

    public boolean isIncludeRemoteHost() {
        return this.includeRemoteHost;
    }

    public void setIncludeRemoteHost(boolean bl) {
        this.includeRemoteHost = bl;
    }

    public boolean isIncludeServerName() {
        return this.includeServerName;
    }

    public void setIncludeServerName(boolean bl) {
        this.includeServerName = bl;
    }

    public boolean isIncludeRequestHeader() {
        return this.includeRequestHeader;
    }

    public void setIncludeRequestHeader(boolean bl) {
        this.includeRequestHeader = bl;
    }

    public boolean isIncludeRequestParameter() {
        return this.includeRequestParameter;
    }

    public void setIncludeRequestParameter(boolean bl) {
        this.includeRequestParameter = bl;
    }

    public boolean isIncludeLocalPort() {
        return this.includeLocalPort;
    }

    public void setIncludeLocalPort(boolean bl) {
        this.includeLocalPort = bl;
    }

    public boolean isIncludeRequestContent() {
        return this.includeRequestContent;
    }

    public void setIncludeRequestContent(boolean bl) {
        this.includeRequestContent = bl;
    }

    public boolean isIncludeResponseContent() {
        return this.includeResponseContent;
    }

    public void setIncludeResponseContent(boolean bl) {
        this.includeResponseContent = bl;
    }
}

