/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.mongodb;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.contrib.mongodb.MongoDBAppenderBase;
import com.mongodb.BasicDBObject;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBAccessEventAppender
extends MongoDBAppenderBase<IAccessEvent> {
    private boolean serverName = true;
    private boolean requestUri = true;
    private boolean requestProtocol = true;
    private boolean requestMethod = true;
    private boolean requestPostContent = true;
    private boolean requestSessionId = true;
    private boolean requestUserAgent = true;
    private boolean requestReferer = true;
    private boolean remoteHost = true;
    private boolean remoteUser = true;
    private boolean remoteAddr = true;
    private boolean responseContentLength = true;
    private boolean responseStatusCode = true;

    protected BasicDBObject toMongoDocument(IAccessEvent event) {
        BasicDBObject doc = new BasicDBObject();
        doc.append("timeStamp", (Object)new Date(event.getTimeStamp()));
        if (this.serverName) {
            doc.append("serverName", (Object)event.getServerName());
        }
        this.addRemote(doc, event);
        this.addRequest(doc, event);
        this.addResponse(doc, event);
        return doc;
    }

    private void addRemote(BasicDBObject parent, IAccessEvent event) {
        BasicDBObject remote = new BasicDBObject();
        String host = event.getRemoteHost();
        if (this.remoteHost && host != null) {
            remote.append("host", (Object)host);
        }
        String remoteUserName = event.getRemoteUser();
        if (this.remoteUser && remoteUserName != null && !remoteUserName.equals("-")) {
            remote.append("user", (Object)remoteUserName);
        }
        String addr = event.getRemoteAddr();
        if (this.remoteAddr && addr != null) {
            remote.append("addr", (Object)addr);
        }
        if (!remote.isEmpty()) {
            parent.put("remote", (Object)remote);
        }
    }

    private void addRequest(BasicDBObject parent, IAccessEvent event) {
        BasicDBObject request = new BasicDBObject();
        String uri = event.getRequestURI();
        if (this.requestUri && uri != null && !uri.equals("-")) {
            request.append("uri", (Object)uri);
        }
        String protocol = event.getProtocol();
        if (this.requestProtocol && protocol != null) {
            request.append("protocol", (Object)protocol);
        }
        String method = event.getMethod();
        if (this.requestMethod && method != null) {
            request.append("method", (Object)method);
        }
        String requestContent = event.getRequestContent();
        if (this.requestPostContent && requestContent != null && !requestContent.equals("")) {
            request.append("postContent", (Object)requestContent);
        }
        String jSessionId = event.getCookie("JSESSIONID");
        if (this.requestSessionId && jSessionId != null && !jSessionId.equals("-")) {
            request.append("sessionId", (Object)jSessionId);
        }
        String userAgent = event.getRequestHeader("User-Agent");
        if (this.requestUserAgent && userAgent != null && !userAgent.equals("-")) {
            request.append("userAgent", (Object)userAgent);
        }
        String referer = event.getRequestHeader("Referer");
        if (this.requestReferer && referer != null && !referer.equals("-")) {
            request.append("referer", (Object)referer);
        }
        if (!request.isEmpty()) {
            parent.put("request", (Object)request);
        }
    }

    private void addResponse(BasicDBObject doc, IAccessEvent event) {
        BasicDBObject response = new BasicDBObject();
        if (this.responseContentLength) {
            response.append("contentLength", (Object)event.getContentLength());
        }
        if (this.responseStatusCode) {
            response.append("statusCode", (Object)event.getStatusCode());
        }
        if (!response.isEmpty()) {
            doc.append("response", (Object)response);
        }
    }

    public void setServerName(boolean serverName) {
        this.serverName = serverName;
    }

    public void setRequestUri(boolean requestUri) {
        this.requestUri = requestUri;
    }

    public void setRequestProtocol(boolean requestProtocol) {
        this.requestProtocol = requestProtocol;
    }

    public void setRequestMethod(boolean requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setRequestPostContent(boolean requestPostContent) {
        this.requestPostContent = requestPostContent;
    }

    public void setRequestSessionId(boolean requestSessionId) {
        this.requestSessionId = requestSessionId;
    }

    public void setRequestUserAgent(boolean requestUserAgent) {
        this.requestUserAgent = requestUserAgent;
    }

    public void setRequestReferer(boolean requestReferer) {
        this.requestReferer = requestReferer;
    }

    public void setRemoteHost(boolean remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteUser(boolean remoteUser) {
        this.remoteUser = remoteUser;
    }

    public void setRemoteAddr(boolean remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setResponseContentLength(boolean responseContentLength) {
        this.responseContentLength = responseContentLength;
    }

    public void setResponseStatusCode(boolean responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }
}

