/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.mongodb;

import ch.qos.logback.contrib.mongodb.DefaultMongoFactory;
import ch.qos.logback.contrib.mongodb.MongoFactory;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;

public abstract class MongoDBAppenderBase<E>
extends UnsynchronizedAppenderBase<E> {
    private Mongo mongo = null;
    private DBCollection eventsCollection = null;
    private String uri = null;
    private MongoFactory mongoFactory;

    public MongoDBAppenderBase() {
        this.mongoFactory = new DefaultMongoFactory();
    }

    public MongoDBAppenderBase(MongoFactory mongoFactory) {
        this.mongoFactory = mongoFactory;
    }

    public void start() {
        try {
            if (this.uri == null) {
                this.addError("Please set a non-null MongoDB URI.");
                return;
            }
            MongoURI mongoURI = new MongoURI(this.uri);
            String string = mongoURI.getDatabase();
            String string2 = mongoURI.getCollection();
            if (string == null || string2 == null) {
                this.addError("Error connecting to MongoDB URI: " + this.uri + " must contain a database and a collection." + " E.g. mongodb://localhost/database.collection");
                return;
            }
            this.mongo = this.mongoFactory.createMongo(mongoURI);
            DB dB = this.mongo.getDB(string);
            String string3 = mongoURI.getUsername();
            char[] cArray = mongoURI.getPassword();
            if (string3 != null && cArray != null) {
                dB.authenticate(string3, cArray);
            }
            this.eventsCollection = dB.getCollection(string2);
            super.start();
        }
        catch (Exception exception) {
            this.addError("Error connecting to MongoDB URI: " + this.uri, exception);
        }
    }

    protected void append(E e) {
        this.eventsCollection.insert(new DBObject[]{this.toMongoDocument(e)});
    }

    protected abstract BasicDBObject toMongoDocument(E var1);

    public void stop() {
        if (this.mongo != null) {
            this.mongo.close();
        }
        super.stop();
    }

    public void setUri(String string) {
        this.uri = string;
    }
}

