/**
 * Copyright (C) 2016, The logback-contrib developers. All rights reserved.
 *
 * This program and the accompanying materials are dual-licensed under
 * either the terms of the Eclipse Public License v1.0 as published by
 * the Eclipse Foundation
 *
 *   or (per the licensee's choosing)
 *
 * under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation.
 */
package ch.qos.logback.contrib.mongodb;

import com.mongodb.Mongo;
import com.mongodb.MongoURI;

import java.net.UnknownHostException;

/**
 * Factory of {@link com.mongodb.Mongo} instances
 */
public class DefaultMongoFactory implements MongoFactory {

    /**
     * Creates a {@link com.mongodb.Mongo} instance
     * @param uri - database URI
     * @return the Mongo instance
     * @throws UnknownHostException
     */
    @Override
    public Mongo createMongo(MongoURI uri) throws UnknownHostException {
        return new Mongo(uri);
    }
}
