/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.mongodb;

import ch.qos.logback.contrib.mongodb.DefaultMongoClientFactory;
import ch.qos.logback.contrib.mongodb.MongoClientFactory;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;

public abstract class MongoDBAppenderBase<E>
extends UnsynchronizedAppenderBase<E> {
    private MongoClient mongoClient = null;
    private DBCollection eventsCollection = null;
    private String uri = null;
    private MongoClientFactory mongoClientFactory;

    public MongoDBAppenderBase() {
        this.mongoClientFactory = new DefaultMongoClientFactory();
    }

    public MongoDBAppenderBase(MongoClientFactory mongoClientFactory) {
        this.mongoClientFactory = mongoClientFactory;
    }

    public void start() {
        try {
            if (this.uri == null) {
                this.addError("Please set a non-null MongoDB URI.");
                return;
            }
            MongoClientURI mongoClientURI = new MongoClientURI(this.uri);
            String string = mongoClientURI.getDatabase();
            String string2 = mongoClientURI.getCollection();
            if (string == null || string2 == null) {
                this.addError("Error connecting to MongoDB URI: " + this.uri + " must contain a database and a collection." + " E.g. mongodb://localhost/database.collection");
                return;
            }
            this.mongoClient = this.mongoClientFactory.createMongoClient(mongoClientURI);
            DB dB = this.mongoClient.getDB(string);
            this.eventsCollection = dB.getCollection(string2);
            super.start();
        }
        catch (Exception exception) {
            this.addError("Error connecting to MongoDB URI: " + this.uri, exception);
        }
    }

    protected void append(E e) {
        this.eventsCollection.insert(new DBObject[]{this.toMongoDocument(e)});
    }

    protected abstract BasicDBObject toMongoDocument(E var1);

    public void stop() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
        super.stop();
    }

    public void setUri(String string) {
        this.uri = string;
    }
}

