/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.db.DBAppender;
import ch.qos.logback.classic.db.DBAppenderHSQLTestFixture;
import ch.qos.logback.classic.db.DBHelper;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DriverManagerConnectionSource;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.MDC;

public class DBAppenderHSQLTest {
    LoggerContext lc;
    Logger logger;
    DBAppender appender;
    DriverManagerConnectionSource connectionSource;
    static DBAppenderHSQLTestFixture DB_APPENDER_HSQL_TEST_FIXTURE;
    int diff = RandomUtil.getPositiveInt();
    int existingRowCount;
    Statement stmt;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        DB_APPENDER_HSQL_TEST_FIXTURE = new DBAppenderHSQLTestFixture();
        DB_APPENDER_HSQL_TEST_FIXTURE.setUp();
    }

    @AfterClass
    public static void afterClass() throws SQLException {
        DB_APPENDER_HSQL_TEST_FIXTURE.tearDown();
    }

    @Before
    public void setUp() throws SQLException {
        this.lc = new LoggerContext();
        this.lc.setName("default");
        this.logger = this.lc.getLogger("root");
        this.appender = new DBAppender();
        this.appender.setName("DB");
        this.appender.setContext((Context)this.lc);
        this.connectionSource = new DriverManagerConnectionSource();
        this.connectionSource.setContext((Context)this.lc);
        this.connectionSource.setDriverClass("org.hsqldb.jdbcDriver");
        this.connectionSource.setUrl(DBAppenderHSQLTest.DB_APPENDER_HSQL_TEST_FIXTURE.url);
        this.connectionSource.setUser(DBAppenderHSQLTest.DB_APPENDER_HSQL_TEST_FIXTURE.user);
        this.connectionSource.setPassword(DBAppenderHSQLTest.DB_APPENDER_HSQL_TEST_FIXTURE.password);
        this.connectionSource.start();
        this.appender.setConnectionSource((ConnectionSource)this.connectionSource);
        this.appender.start();
        this.stmt = this.connectionSource.getConnection().createStatement();
        this.existingRowCount = this.existingRowCount(this.stmt);
    }

    @After
    public void tearDown() throws SQLException {
        this.logger = null;
        this.lc = null;
        this.appender = null;
        this.connectionSource = null;
        this.stmt.close();
    }

    int existingRowCount(Statement stmt) throws SQLException {
        ResultSet rs = stmt.executeQuery("SELECT count(*) FROM logging_event");
        int result = -1;
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    @Test
    public void testAppendLoggingEvent() throws SQLException {
        ILoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.lc);
        ResultSet rs = null;
        rs = this.stmt.executeQuery("SELECT * FROM logging_event where EVENT_ID = " + this.existingRowCount);
        if (rs.next()) {
            Assert.assertEquals((long)event.getTimeStamp(), (long)rs.getLong(1));
            Assert.assertEquals((Object)event.getFormattedMessage(), (Object)rs.getString(2));
            Assert.assertEquals((Object)event.getLoggerName(), (Object)rs.getString(3));
            Assert.assertEquals((Object)event.getLevel().toString(), (Object)rs.getString(4));
            Assert.assertEquals((Object)event.getThreadName(), (Object)rs.getString(5));
            Assert.assertEquals((long)DBHelper.computeReferenceMask((ILoggingEvent)event), (long)rs.getShort(6));
            Assert.assertEquals((Object)String.valueOf(this.diff), (Object)rs.getString(7));
            StackTraceElement callerData = event.getCallerData()[0];
            Assert.assertEquals((Object)callerData.getFileName(), (Object)rs.getString(11));
            Assert.assertEquals((Object)callerData.getClassName(), (Object)rs.getString(12));
            Assert.assertEquals((Object)callerData.getMethodName(), (Object)rs.getString(13));
        } else {
            Assert.fail((String)"No row was inserted in the database");
        }
        rs.close();
    }

    @Test
    public void testAppendThrowable() throws SQLException {
        ILoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        ResultSet rs = null;
        rs = this.stmt.executeQuery("SELECT * FROM LOGGING_EVENT_EXCEPTION where EVENT_ID = " + this.existingRowCount);
        rs.next();
        String expected = "java.lang.Exception: test Ex";
        String firstLine = rs.getString(3);
        Assert.assertTrue((String)("[" + firstLine + "] does not match [" + expected + "]"), (boolean)firstLine.contains(expected));
        int i = 0;
        while (rs.next()) {
            expected = event.getThrowableProxy().getStackTraceElementProxyArray()[i].toString();
            String st = rs.getString(3);
            Assert.assertTrue((String)("[" + st + "] does not match [" + expected + "]"), (boolean)st.contains(expected));
            ++i;
        }
        Assert.assertTrue((i != 0 ? 1 : 0) != 0);
        rs.close();
    }

    @Test
    public void testContextInfo() throws SQLException {
        this.lc.putProperty("testKey1", "testValue1");
        MDC.put((String)("k" + this.diff), (String)("v" + this.diff));
        ILoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM LOGGING_EVENT_PROPERTY  WHERE EVENT_ID = " + this.existingRowCount);
        Map map = this.appender.mergePropertyMaps(event);
        System.out.println("ma.size=" + map.size());
        int i = 0;
        while (rs.next()) {
            String key = rs.getString(2);
            Assert.assertEquals(map.get(key), (Object)rs.getString(3));
            ++i;
        }
        Assert.assertTrue((map.size() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)map.size(), (long)i);
        rs.close();
    }

    @Test
    public void testAppendMultipleEvents() throws SQLException {
        int numEvents = 3;
        for (int i = 0; i < numEvents; ++i) {
            ILoggingEvent event = this.createLoggingEvent();
            this.appender.append((Object)event);
        }
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event WHERE EVENT_ID >=" + this.existingRowCount);
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)numEvents, (long)count);
        rs.close();
    }

    private ILoggingEvent createLoggingEvent() {
        return new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message", (Throwable)new Exception("test Ex"), (Object[])new Integer[]{this.diff});
    }
}

